/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.PluginManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PropertyHelper {
    public static final Logger LOGGER = Logger.getLogger(PropertyHelper.class);

    public static int getIntProperty(Properties p, String property) {
        return PropertyHelper.getIntProperty(p, property, -1);
    }

    public static int getIntProperty(Properties p, String property, int defaultValue) {
        String str = p.getProperty(property, Integer.toString(defaultValue));
        int result = defaultValue;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)("Invalid value for int property: " + property + "=" + str + "(using default: " + defaultValue + ")."));
        }
        return result;
    }

    public static boolean getBoolProperty(Properties props, String property, boolean def) {
        String value = props.getProperty(property);
        if (value == null) {
            return def;
        }
        if (value.trim().equals("")) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    public static boolean getBoolProperty(Properties props, String property) {
        return PropertyHelper.getBoolProperty(props, property, false);
    }

    public static Collection<String> parseListString(String list, StringTokenizer tok, boolean trim) {
        Vector<String> result = new Vector<String>(tok.countTokens());
        try {
            while (tok.hasMoreTokens()) {
                String currentToken = tok.nextToken();
                if (trim) {
                    currentToken = currentToken.trim();
                }
                result.add(currentToken);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.error((Object)("PluginLoader: " + String.valueOf(e) + " when parsing " + list + " as list!"));
        }
        return result;
    }

    public static Collection<String> parseListString(String list) {
        return PropertyHelper.parseListString(list, new StringTokenizer(list, ","), true);
    }

    public static Collection<String> parsePathListString(String list) {
        return PropertyHelper.parseListString(list, new StringTokenizer(list, File.pathSeparator), false);
    }

    public static List<String> getListProperty(Properties props, String propName) {
        boolean goon = true;
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (goon) {
            String currentProp = props.getProperty(propName + "_" + i);
            if (currentProp == null) {
                goon = false;
                break;
            }
            result.add(currentProp);
            ++i;
        }
        return result;
    }

    public static Class<?> getClassProperty(Properties props, String propName, Class<?> typeRequest, Class<?> def) {
        Class<?> result = null;
        String className = props.getProperty(propName);
        if (className != null) {
            try {
                result = Class.forName(className, true, PluginManager.getInstance().getBottomClassLoader());
                if (!typeRequest.isAssignableFrom(result)) {
                    LOGGER.error((Object)("Property " + propName + " is invalid, ignoring: " + result.getName() + " is not a subtype of " + typeRequest.getName() + "."));
                    result = null;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("Property " + propName + " is invalid, ignoring: Class " + className + " not found."));
                result = null;
            }
        }
        if (result == null) {
            result = def;
        }
        return result;
    }

    public static Class<?> getClassProperty(Properties props, String propName, Class<?> typeRequest) {
        return PropertyHelper.getClassProperty(props, propName, typeRequest, null);
    }
}

