/*
 * Decompiled with CFR 0.152.
 */
package de.renew.mxml;

import de.renew.mxml.MXMLCommandCenter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MXMLHelper {
    private StringBuilder _attributes;
    private StringBuilder _data;
    private Date _date;
    private String _originator;
    private SimpleDateFormat _form;
    private String _defaultHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!-- MXML version 1.0 --><!-- This is a process event log created to be analyzed by ProM. When analyzing please discard the events of type \"ignore\"--><!-- ProM is the process mining framework. It can be freely obtained at http://www.processmining.org/. --><WorkflowLog xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://is.tm.tue.nl/research/processmining/WorkflowLog.xsd\" description=\"PAOSE Workflow log\"><Source program=\"Renew Mulan\"/>";
    private String _processInstanceDefaultHeader = this._defaultHeader + "<Process id=\"DEFAULT\" description=\"Default process\">";
    private String _auditTrailDefaultHeader = this._processInstanceDefaultHeader + "<ProcessInstance id=\"DEFAULT\" description=\"Default process instance\">";

    public MXMLHelper() {
        this._attributes = new StringBuilder();
        this._data = new StringBuilder();
        this._data.append("<Data>");
        this._data.append("</Data>");
        this._date = new Date();
        MXMLCommandCenter var = MXMLCommandCenter.getInstance();
        this._originator = var.getUserName();
        this._form = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public void addAttribute(String name, String value) {
        String temp = "<Attribute name=\"" + name + "\">" + value + "</Attribute>";
        this._attributes.append(temp);
    }

    public String generateAudiTrail(String element, String type) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(MXMLCommandCenter.FILE));
            String sCurrentLine = br.readLine();
            StringBuilder trail = new StringBuilder();
            trail.append("<AuditTrailEntry>");
            if (this._attributes.length() > 0) {
                this._data.insert(6, this._attributes);
                trail.append((CharSequence)this._data);
            }
            trail.append("<WorkflowModelElement>" + element + "</WorkflowModelElement>");
            trail.append("<EventType>" + type + "</EventType>");
            String st = this._form.format(this._date);
            trail.append("<Timestamp>" + st + "</Timestamp>");
            trail.append("<Originator>" + this._originator + "</Originator>");
            trail.append("</AuditTrailEntry>\n");
            if (sCurrentLine == null) {
                trail.insert(0, this._auditTrailDefaultHeader);
                System.out.println("INFO: New log file generated");
            }
            br.close();
            return trail.toString();
        }
        catch (IOException e) {
            MXMLCommandCenter.lockEnvironment();
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "";
        }
    }

    public String generateProcessInstance(String id, String prop) {
        BufferedReader br = null;
        try {
            Object ret = "";
            br = new BufferedReader(new FileReader(MXMLCommandCenter.FILE));
            String sCurrentLine = br.readLine();
            if (sCurrentLine == null) {
                ret = this._processInstanceDefaultHeader + "<ProcessInstance id=\"";
                System.out.println("INFO: New log file generated");
            } else {
                ret = "</ProcessInstance><ProcessInstance id=\"";
                System.out.println("INFO: Log file updated");
            }
            ret = (String)ret + id + "\" description=\"" + prop + "\">";
            if (this._attributes.length() > 0) {
                this._data.insert(6, this._attributes);
                ret = (String)ret + String.valueOf(this._data);
            }
            br.close();
            return ret;
        }
        catch (IOException e) {
            MXMLCommandCenter.lockEnvironment();
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "";
        }
    }

    public String generateProcess(String id, String prop) {
        BufferedReader br = null;
        try {
            Object ret = "";
            br = new BufferedReader(new FileReader(MXMLCommandCenter.FILE));
            String sCurrentLine = br.readLine();
            if (sCurrentLine == null) {
                ret = this._defaultHeader + "<ProcessInstance id=\"";
                System.out.println("INFO: New log file generated");
            } else {
                ret = "</Process><Process id=\"";
                System.out.println("INFO: Log file updated");
            }
            ret = (String)ret + id + "\" description=\"" + prop + "\">";
            if (this._attributes.length() > 0) {
                this._data.insert(6, this._attributes);
                ret = (String)ret + String.valueOf(this._data);
            }
            br.close();
            return ret;
        }
        catch (IOException e) {
            MXMLCommandCenter.lockEnvironment();
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "";
        }
    }
}

