/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging;

public enum CliColor {
    BACKGROUND_BLACK("40"),
    BACKGROUND_BLUE("44"),
    BACKGROUND_CYAN("46"),
    BACKGROUND_GREEN("42"),
    BACKGROUND_LIGHT_GRAY("47"),
    BACKGROUND_MAGENTA("45"),
    BACKGROUND_RED("41"),
    BACKGROUND_YELLOW("43"),
    BLACK("30"),
    BLUE("34"),
    BOLD("1"),
    CROSSED_OUT("9"),
    ITALIC("3"),
    NORMAL("0"),
    UNDERLINE("4"),
    CYAN("36"),
    GREEN("32"),
    PURPLE("35"),
    RED("31"),
    WHITE("37"),
    YELLOW("33");

    private final String _config;

    private CliColor(String config) {
        this._config = config;
    }

    public static String color(String str, CliColor ... formats) {
        StringBuilder join = new StringBuilder();
        for (CliColor format : formats) {
            if (join.length() != 0) {
                join.append(';');
            }
            join.append(format.toString());
        }
        return "\u001b[" + String.valueOf(join) + "m" + str + "\u001b[m";
    }

    public String color(String str) {
        return CliColor.color(str, this);
    }

    public String toString() {
        return this._config;
    }
}

