/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.search.range.SearchRange;
import de.renew.refactoring.wizard.WrapLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;

public class SearchRangeSelectPanel
extends JPanel {
    private static final long serialVersionUID = -4669316167221128799L;
    private static final Logger LOGGER = Logger.getLogger(SearchRangeSelectPanel.class);
    private Map<JRadioButton, SearchRange> _buttons;

    public SearchRangeSelectPanel(List<SearchRange> searchRanges) {
        this(searchRanges, searchRanges.size() - 1);
    }

    public SearchRangeSelectPanel(List<SearchRange> searchRanges, int defaultIndex) {
        this.createRadioButtons(searchRanges, defaultIndex);
        this.setLayout(new WrapLayout());
    }

    private void createRadioButtons(List<SearchRange> searchRanges, int defaultIndex) {
        JLabel intro = new JLabel("Search Range:");
        this.add(intro);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._buttons = new HashMap<JRadioButton, SearchRange>();
        int i = 0;
        for (SearchRange searchRange : searchRanges) {
            JRadioButton button = new JRadioButton(searchRange.description());
            button.setSelected(i == defaultIndex);
            this._buttons.put(button, searchRange);
            this.add(button);
            buttonGroup.add(button);
            ++i;
        }
    }

    public SearchRange getValue() {
        for (JRadioButton button : this._buttons.keySet()) {
            if (!button.isSelected()) continue;
            return this._buttons.get(button);
        }
        return null;
    }
}

