/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.search.range;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class NetpathFiles {
    private static final Logger LOGGER = Logger.getLogger(NetpathFiles.class);

    private NetpathFiles() {
    }

    public static List<File> files(String extension, String pattern) {
        ArrayList<File> files = new ArrayList<File>();
        for (PathEntry pathEntry : NetpathFiles.netPathEntries()) {
            LOGGER.debug((Object)("Processing net path entry: " + pathEntry.path));
            File path = new File(pathEntry.path);
            files.addAll(NetpathFiles.listFiles(path, extension));
        }
        return files;
    }

    public static List<File> files(List<String> extensions, String pattern) {
        ArrayList<File> files = new ArrayList<File>();
        for (String extension : extensions) {
            files.addAll(NetpathFiles.files(extension, pattern));
        }
        return files;
    }

    private static List<PathEntry> netPathEntries() {
        IPlugin simulatorPlugin = (IPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
        PathEntry[] entries = StringUtil.canonizePaths((String[])StringUtil.splitPaths((String)simulatorPlugin.getProperties().getProperty("de.renew.netPath")));
        ArrayList<PathEntry> result = new ArrayList<PathEntry>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            LOGGER.debug((Object)("Processing net path entry: " + entries[i].path));
            if (entries[i].isClasspathRelative) continue;
            result.add(entries[i]);
        }
        return result;
    }

    private static List<File> listFiles(File directory, final String extension) {
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return StringUtil.getExtension((String)name).toLowerCase().equals(extension.toLowerCase());
            }
        });
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }
}

