/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.renamevariable.VariableNameMatch;
import de.renew.refactoring.search.DrawingSearcher;
import de.renew.refactoring.search.range.SingleDrawingSearchRange;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class RenameVariableReferenceFinder
extends DrawingSearcher<VariableNameMatch> {
    private static final Logger LOGGER = Logger.getLogger(RenameVariableReferenceFinder.class);
    private final VariableParser _parser;
    private final String _name;

    RenameVariableReferenceFinder(VariableParser parser, Drawing drawing, String name) {
        super(new SingleDrawingSearchRange(drawing));
        this._parser = parser;
        this._name = name;
    }

    @Override
    protected List<VariableNameMatch> searchDrawing(Drawing drawing) {
        ArrayList<VariableNameMatch> references = new ArrayList<VariableNameMatch>();
        FigureEnumeration figures = drawing.figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            if (!(figure instanceof CPNTextFigure)) continue;
            CPNTextFigure textFigure = (CPNTextFigure)figure;
            String text = textFigure.getText();
            List<StringMatch> allVariables = figure instanceof DeclarationFigure ? this._parser.findVariablesInDeclarationNode() : this._parser.findVariables(text);
            for (StringMatch stringMatch : allVariables) {
                if (!stringMatch.match().equals(this._name)) continue;
                LOGGER.debug((Object)("found reference: " + String.valueOf(stringMatch)));
                references.add(new VariableNameMatch(drawing, textFigure, stringMatch));
            }
        }
        return references;
    }
}

