/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamevariable;

import CH.ifa.draw.framework.Figure;
import de.renew.gui.CPNDrawingView;
import de.renew.gui.CPNTextFigure;
import de.renew.refactoring.inline.InlineControllerWithListener;
import de.renew.refactoring.inline.InlineStep;
import de.renew.refactoring.inline.InlineStepListener;
import de.renew.refactoring.inline.PopupMenuStep;
import de.renew.refactoring.inline.RestrictedEditingTextFieldStep;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.renamevariable.NoVariableSelectedException;
import de.renew.refactoring.renamevariable.RenameVariableRefactoring;
import de.renew.refactoring.renamevariable.Variable;
import de.renew.refactoring.renamevariable.VariableNameMatch;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class RenameVariableInlineController
extends InlineControllerWithListener {
    private static final Logger LOGGER = Logger.getLogger(RenameVariableInlineController.class);
    private State _state = State.STARTED;
    private final RenameVariableRefactoring _refactoring;
    private final CPNDrawingView _container;
    private RestrictedEditingTextFieldStep _textFieldStep;
    private Vector<Figure> _referencingFigures;

    public RenameVariableInlineController(VariableParser parser, CPNDrawingView container) throws NoVariableSelectedException {
        this._container = container;
        this._refactoring = new RenameVariableRefactoring(parser, container.drawing(), container.selection());
        this.nextStep();
    }

    @Override
    public InlineStep nextStep() {
        if (this._state == State.STARTED) {
            ArrayList<Variable> variables = new ArrayList<Variable>(this._refactoring.getVariablesInSelection());
            if (variables.size() == 1) {
                this._refactoring.setSelectedVariable((Variable)variables.get(0));
                this._state = State.SELECTED_VARIABLE;
            } else {
                Point origin = this._refactoring.getSelectedTextFigure().center();
                Collections.sort(variables);
                return this.makeSelectVariableStep(origin, variables);
            }
        }
        if (this._state == State.SELECTED_VARIABLE) {
            this._state = State.RENAMING;
            this._refactoring.findReferences();
            this._textFieldStep = this.makeEditVariableNameStep();
            return this._textFieldStep;
        }
        if (this._state == State.RENAMING) {
            this._state = State.FINISHED;
            this._textFieldStep.endEdit();
            this._textFieldStep = null;
            if (!this._refactoring.enteredValidVariableName()) {
                this._refactoring.restorePreviousTexts();
            }
            this._container.selection().removeAll(this._referencingFigures);
            this._container.checkDamage();
            this.informListenersFinished();
        }
        return null;
    }

    private PopupMenuStep<Variable> makeSelectVariableStep(Point origin, List<Variable> variables) {
        PopupMenuStep<Variable> step = new PopupMenuStep<Variable>((Container)this._container, origin, variables){

            @Override
            public String titleForEntry(Variable entry) {
                return "Rename " + String.valueOf(entry);
            }

            @Override
            public ActionListener actionListenerForEntry(Variable entry) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RenameVariableInlineController.this._state = State.SELECTED_VARIABLE;
                        JMenuItem item = (JMenuItem)e.getSource();
                        Variable selected = (Variable)this.getEntryForMenuItem(item);
                        RenameVariableInlineController.this._refactoring.setSelectedVariable(selected);
                        RenameVariableInlineController.this.nextStep();
                    }
                };
            }
        };
        step.addListener(new InlineStepListener(){

            @Override
            public void inlineStepFinished() {
            }

            @Override
            public void inlineStepCancelled() {
                RenameVariableInlineController.this.informListenersFinished();
            }
        });
        return step;
    }

    private RestrictedEditingTextFieldStep makeEditVariableNameStep() {
        StringMatch variableNameMatch = this._refactoring.getSelectedVariableStringMatch();
        CPNTextFigure selectedTextFigure = this._refactoring.getSelectedTextFigure();
        this._referencingFigures = new Vector();
        for (VariableNameMatch match : this._refactoring.getReferences()) {
            this._referencingFigures.add((Figure)match.getTextFigure());
        }
        this._container.addToSelectionAll(this._referencingFigures);
        this._container.checkDamage();
        return new RestrictedEditingTextFieldStep((Container)this._container, selectedTextFigure, variableNameMatch){

            @Override
            public void editedTextChanged(String text) {
                RenameVariableInlineController.this._refactoring.setNewName(text);
                RenameVariableInlineController.this.updateTextFieldBorderColor();
                RenameVariableInlineController.this._refactoring.restorePreviousTexts();
                RenameVariableInlineController.this._refactoring.replaceVariables();
            }

            @Override
            protected KeyListener textFieldKeyListener() {
                return new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10 && RenameVariableInlineController.this._refactoring.enteredValidVariableName()) {
                            RenameVariableInlineController.this.nextStep();
                        }
                    }
                };
            }

            @Override
            protected MouseListener containerMouseListener() {
                if (this._mouseListener == null) {
                    this._mouseListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (RenameVariableInlineController.this._state == State.RENAMING) {
                                RenameVariableInlineController.this.nextStep();
                            }
                        }
                    };
                }
                return this._mouseListener;
            }
        };
    }

    private void updateTextFieldBorderColor() {
        Color borderColor;
        Color color = borderColor = this._refactoring.enteredValidVariableName() ? Color.BLACK : Color.RED;
        if (this._textFieldStep != null) {
            this._textFieldStep.setBorderColor(borderColor);
        }
    }

    private static enum State {
        STARTED,
        SELECTED_VARIABLE,
        RENAMING,
        FINISHED;

    }
}

