/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.IteratorEditor;
import de.renew.refactoring.edit.TextFigureMatchSorter;
import de.renew.refactoring.match.TextFigureMatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TextFigureMatchEditor<T extends TextFigureMatch, R>
extends IteratorEditor<T, R> {
    private static final Logger LOGGER = Logger.getLogger(TextFigureMatchEditor.class);
    private final Map<T, String> _previousTexts;

    public TextFigureMatchEditor(List<T> matches) {
        super(new TextFigureMatchSorter<T>().sorted(matches));
        this._previousTexts = this.previousTexts(matches);
    }

    @Override
    public String getCurrentEditString() {
        return ((TextFigureMatch)this.getCurrentEdit()).getDrawing().getName();
    }

    protected void changeText(T match, String newText) {
        ((TextFigureMatch)match).getTextFigure().setText(newText);
        ((TextFigureMatch)match).getTextFigure().changed();
        ((TextFigureMatch)match).getDrawing().checkDamage();
    }

    private Map<T, String> previousTexts(List<T> matches) {
        HashMap<TextFigureMatch, String> previousTexts = new HashMap<TextFigureMatch, String>();
        for (TextFigureMatch match : matches) {
            previousTexts.put(match, match.getText());
        }
        return previousTexts;
    }

    public void restorePreviousTexts() {
        for (TextFigureMatch match : this._previousTexts.keySet()) {
            String previous = this._previousTexts.get(match);
            LOGGER.debug((Object)("Restoring previous text: " + previous));
            this.changeText(match, previous);
        }
    }
}

