/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.call.SynchronisationOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.ChannelBinder;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.unify.Variable;
import de.renew.util.Lock;
import de.renew.util.Orderer;
import de.renew.util.Semaphor;

public class SynchronisationRequest
implements Searchable,
Triggerable {
    private ChannelTarget _channelTarget;
    private String _channelName;
    Tuple _parameters;
    Tuple _resultParameters;
    Semaphor _resultSemaphor;
    boolean _completed;
    final long _lockOrder;
    final Lock _lock;
    private TriggerCollection _triggers = new TriggerCollectionImpl((Triggerable)this);

    public SynchronisationRequest(ChannelTarget channelTarget, String channelName, Tuple parameters) {
        this._channelTarget = channelTarget;
        this._channelName = channelName;
        this._parameters = parameters;
        this._resultParameters = null;
        this._resultSemaphor = new Semaphor();
        this._completed = false;
        this._lockOrder = Orderer.getTicket();
        this._lock = new Lock();
    }

    public static Tuple synchronize(ChannelTarget channelTarget, String channelName, Tuple parameters) {
        SynchronisationRequest request = new SynchronisationRequest(channelTarget, channelName, parameters);
        request.proposeSearch();
        return request.getResult();
    }

    public TriggerCollection triggers() {
        return this._triggers;
    }

    public void proposeSearch() {
        SearchQueue.includeNow((Searchable)this);
    }

    public Tuple getResult() {
        this._resultSemaphor.P();
        return this._resultParameters;
    }

    public synchronized void startSearch(final Searcher searcher) {
        final SynchronisationRequest object = this;
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                if (SynchronisationRequest.this._completed) {
                    return;
                }
                Variable paramVariable = new Variable((Object)SynchronisationRequest.this._parameters, searcher.recorder);
                try {
                    searcher.calcChecker.addLateVariable(paramVariable, searcher.recorder);
                }
                catch (Impossible e) {
                    throw new RuntimeException("Calculation checker refused to make fresh variable late.");
                }
                Variable targetVariable = new Variable((Object)SynchronisationRequest.this._channelTarget, searcher.recorder);
                ChannelBinder initialBinder = new ChannelBinder(targetVariable, SynchronisationRequest.this._channelName, paramVariable, false);
                searcher.addBinder((Binder)initialBinder);
                SynchronisationOccurrence occurrence = new SynchronisationOccurrence(object);
                searcher.addOccurrence((Occurrence)occurrence);
                searcher.search();
                searcher.removeOccurrence((Occurrence)occurrence);
                searcher.removeBinder((Binder)initialBinder);
                searcher.recorder.restore();
            }
        });
    }
}

