/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.pt;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.formalism.base.AbstractSingleNetCompiler;
import de.renew.net.ConstantTokenSource;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.Arc;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.SyntaxException;
import de.renew.unify.Tuple;
import java.util.Collection;
import java.util.Iterator;

public class SinglePTNetCompiler
extends AbstractSingleNetCompiler {
    public String checkDeclarationNode(String inscr, boolean special, ShadowNet shadowNet) throws SyntaxException {
        throw new SyntaxException("Declaration node is not allowed.");
    }

    public String checkArcInscription(String inscr, boolean special, ShadowNet shadowNet) throws SyntaxException {
        SinglePTNetCompiler.parseNumber(inscr);
        return "inscription";
    }

    public String checkTransitionInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        throw new SyntaxException("Transition inscription is not allowed.");
    }

    public String checkPlaceInscription(String inscr, boolean special, ShadowNet shadowNet) throws SyntaxException {
        SinglePTNetCompiler.parseNumber(inscr);
        return "initialMarking";
    }

    private static int parseNumber(String inscr) throws SyntaxException {
        try {
            return Integer.parseInt(inscr.trim());
        }
        catch (NumberFormatException nfe) {
            throw new SyntaxException("Number expected", (Throwable)nfe).addObject((Object)inscr);
        }
    }

    protected static int parseNumericalInscription(ShadowInscribable inscribable, int defaultValue, int minValue) throws SyntaxException {
        int result = defaultValue;
        boolean inscriptionFound = false;
        for (Object elem : inscribable.elements()) {
            if (elem instanceof ShadowInscription) {
                if (inscriptionFound) {
                    throw new SyntaxException("Multiple inscriptions not supported").addObject((Object)inscribable);
                }
                inscriptionFound = true;
                result = SinglePTNetCompiler.parseNumber(((ShadowInscription)elem).inscr);
                continue;
            }
            if (elem instanceof ShadowArc) continue;
            throw new SyntaxException("Unsupported inscription").addObject((Object)inscribable).addObject(elem);
        }
        if (result < minValue) {
            throw new SyntaxException("Inscribed value must not be lower than " + minValue).addObject((Object)inscribable);
        }
        return result;
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place) throws SyntaxException {
        int marking = SinglePTNetCompiler.parseNumericalInscription((ShadowInscribable)shadowPlace, 0, 0);
        for (int i = 0; i < marking; ++i) {
            place.add((TokenSource)new ConstantTokenSource((Object)Tuple.NULL));
        }
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        int shadowArcType = shadowArc.shadowArcType;
        if (shadowArcType != 1) {
            throw new SyntaxException("Unsupported arc type").addObject((Object)shadowArc);
        }
        int arcType = shadowArc.placeToTransition ? -1 : 1;
        int multiplicity = SinglePTNetCompiler.parseNumericalInscription((ShadowInscribable)shadowArc, 1, 1);
        Transition transition = this.lookup.get(shadowArc.transition);
        Place place = this.lookup.get(shadowArc.place);
        for (int i = 0; i < multiplicity; ++i) {
            Arc arc = new Arc(place, transition, arcType, (Expression)new ConstantExpression(null, (Object)Tuple.NULL), ConstantExpression.doubleZeroExpression);
            transition.add((TransitionInscription)arc);
        }
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription inscription) throws SyntaxException {
        throw new SyntaxException("Transitions may not carry inscriptions").addObject((Object)inscription);
    }

    @Override
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        Iterator iterator = shadowNet.elements().iterator();
        while (iterator.hasNext()) {
            Object elem = iterator.next();
            if (!(elem instanceof ShadowDeclarationNode)) continue;
            SyntaxException e = new SyntaxException("Declaration node is not allowed.");
            e.addObject(elem);
            while (iterator.hasNext()) {
                elem = iterator.next();
                if (!(elem instanceof ShadowDeclarationNode)) continue;
                e.addObject(elem);
            }
            throw e;
        }
    }
}

