/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.bool;

import de.renew.expression.CallExpression;
import de.renew.expression.ConstantExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.LocalVariable;
import de.renew.expression.TupleExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.bool.LocalVariableSet;
import de.renew.formalism.function.BasicFunction;
import de.renew.net.ConstantTokenSource;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.Arc;
import de.renew.net.inscription.ExpressionInscription;
import de.renew.net.inscription.GuardInscription;
import de.renew.net.inscription.RangeEnumeratorInscription;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowPreprocessor;
import de.renew.shadow.ShadowTransition;
import de.renew.shadow.SyntaxException;
import de.renew.util.StringUtil;
import de.renew.util.Types;
import de.renew.util.Value;
import java.io.Serializable;
import java.util.Vector;

public class SingleBoolNetCompiler
implements ShadowCompiler {
    private static final Value VALUE_0 = new Value((Object)0);
    private static final Value VALUE_1 = new Value((Object)1);
    private static final Expression EXPR_0 = new ConstantExpression(Types.UNTYPED, (Object)VALUE_0);
    private static final Expression EXPR_1 = new ConstantExpression(Types.UNTYPED, (Object)VALUE_1);
    private static final LocalVariable LOCAL_VAR_ACT = new LocalVariable("act");
    private static final VariableExpression LOC_VAR_EXPR_ACT = new VariableExpression(Types.UNTYPED, LOCAL_VAR_ACT);
    private int _placeNum;
    private int _transNum;
    private int _varNum;
    private ShadowLookup _lookup;

    public void set_loopbackNetLoader(NetLoader loopbackNetLoader) {
    }

    public void setShadowLookup(ShadowLookup lookup) {
        this._lookup = lookup;
    }

    public Net createNet(String name) {
        return new Net(name);
    }

    public ShadowPreprocessor[] getRequiredPreprocessors() {
        return new ShadowPreprocessor[0];
    }

    String compileTransitionInscriptions(ShadowTransition shadowTransition, Vector<Place> inPlaces, Vector<Place> outPlaces) throws SyntaxException {
        String mode = null;
        for (Object elem : shadowTransition.elements()) {
            if (elem instanceof ShadowInscription) {
                String inscr = StringUtil.unspace((String)((ShadowInscription)elem).inscr);
                if ("and".equals(inscr) || "or".equals(inscr) || "xor".equals(inscr)) {
                    if (mode != null) {
                        throw new SyntaxException("Too many inscriptions.").addObject((Object)shadowTransition);
                    }
                    mode = inscr;
                    continue;
                }
                throw new SyntaxException("Expected one of: and, or, xor.").addObject(elem);
            }
            if (elem instanceof ShadowArc) {
                ShadowArc arc = (ShadowArc)elem;
                Place place = this._lookup.get(arc.place);
                if (arc.shadowArcType == 2) {
                    inPlaces.addElement(place);
                    outPlaces.addElement(place);
                    continue;
                }
                if (arc.shadowArcType == 1) {
                    if (arc.placeToTransition) {
                        inPlaces.addElement(place);
                        continue;
                    }
                    outPlaces.addElement(place);
                    continue;
                }
                throw new SyntaxException("Unsupported arc type").addObject((Object)arc);
            }
            throw new SyntaxException("Unsupported transition inscription").addObject((Object)shadowTransition).addObject(elem);
        }
        return mode;
    }

    LocalVariable createAnonVariable() {
        return new LocalVariable(String.valueOf(this._varNum++), false);
    }

    LocalVariable createPlaceVariable(LocalVariableSet variables, String prefix, Place place) {
        String name = place.getName();
        if (name == null) {
            return this.createAnonVariable();
        }
        return variables.create(prefix + name);
    }

    void compile(Net net, ShadowPlace shadowPlace) throws SyntaxException {
        Object pname = shadowPlace.getName();
        if (pname == null) {
            ++this._placeNum;
            pname = "P" + this._placeNum;
        }
        Place place = new Place(net, (String)pname, new NetElementID(shadowPlace.getID()));
        place.setTrace(shadowPlace.getTrace());
        this._lookup.set(shadowPlace, place);
        for (Object elem : shadowPlace.elements()) {
            if (elem instanceof ShadowInscription) {
                Value token;
                String inscr = StringUtil.unspace((String)((ShadowInscription)elem).inscr);
                if ("0".equals(inscr) || "false".equals(inscr)) {
                    token = VALUE_0;
                } else if ("1".equals(inscr) || "true".equals(inscr)) {
                    token = VALUE_1;
                } else {
                    throw new SyntaxException("Expected one of: 0, 1, true, false.").addObject(elem);
                }
                place.add((TokenSource)new ConstantTokenSource((Object)token));
                continue;
            }
            if (elem instanceof ShadowArc) continue;
            throw new SyntaxException("Unsupported place inscription: " + String.valueOf(elem.getClass())).addObject((Object)shadowPlace).addObject(elem);
        }
    }

    void compile(Net net, ShadowTransition shadowTransition) throws SyntaxException {
        CallExpression compareExpr;
        Arc arc;
        VariableExpression expr;
        Place place;
        Arc arc2;
        Place place2;
        int i;
        Object tname = shadowTransition.getName();
        if (tname == null) {
            ++this._transNum;
            tname = "T" + this._transNum;
        }
        Transition transition = new Transition(net, (String)tname, new NetElementID(shadowTransition.getID()));
        transition.setTrace(shadowTransition.getTrace());
        this._lookup.set(shadowTransition, transition);
        Vector<Place> inPlaces = new Vector<Place>();
        Vector<Place> outPlaces = new Vector<Place>();
        String mode = this.compileTransitionInscriptions(shadowTransition, inPlaces, outPlaces);
        if (mode == null) {
            mode = "and";
        }
        LocalVariableSet variables = new LocalVariableSet();
        if ("and".equals(mode)) {
            for (i = 0; i < inPlaces.size(); ++i) {
                place2 = inPlaces.elementAt(i);
                arc2 = new Arc(place2, transition, -1, (Expression)LOC_VAR_EXPR_ACT, ConstantExpression.doubleZeroExpression);
                arc2.setTrace(shadowTransition.getTrace());
                transition.add((TransitionInscription)arc2);
            }
        }
        if ("or".equals(mode) || "xor".equals(mode)) {
            Expression sum = EXPR_0;
            for (int i2 = 0; i2 < inPlaces.size(); ++i2) {
                place = inPlaces.elementAt(i2);
                expr = new VariableExpression(Types.UNTYPED, this.createPlaceVariable(variables, "in", place));
                arc = new Arc(place, transition, -1, (Expression)expr, ConstantExpression.doubleZeroExpression);
                arc.setTrace(shadowTransition.getTrace());
                transition.add((TransitionInscription)arc);
                sum = new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{sum, expr}), (Function)BasicFunction.PLUS);
            }
            if ("or".equals(mode)) {
                Function & Serializable func = (Function & Serializable)arg -> {
                    if (VALUE_0.equals(arg)) {
                        return VALUE_0;
                    }
                    return VALUE_1;
                };
                EqualsExpression assignExpr = new EqualsExpression(Types.UNTYPED, (Expression)LOC_VAR_EXPR_ACT, (Expression)new CallExpression(Types.UNTYPED, sum, (Function)func));
                transition.add((TransitionInscription)new ExpressionInscription((Expression)assignExpr));
            } else {
                EqualsExpression assignExpr = new EqualsExpression(Types.UNTYPED, (Expression)LOC_VAR_EXPR_ACT, sum);
                transition.add((TransitionInscription)new ExpressionInscription((Expression)assignExpr));
                compareExpr = new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{sum, EXPR_1}), (Function)BasicFunction.LESSEQUAL);
                transition.add((TransitionInscription)new GuardInscription((Expression)compareExpr));
            }
        }
        if ("and".equals(mode)) {
            for (i = 0; i < outPlaces.size(); ++i) {
                place2 = outPlaces.elementAt(i);
                arc2 = new Arc(place2, transition, 1, (Expression)LOC_VAR_EXPR_ACT, ConstantExpression.doubleZeroExpression);
                arc2.setTrace(shadowTransition.getTrace());
                transition.add((TransitionInscription)arc2);
            }
        }
        if ("or".equals(mode)) {
            Expression sum = EXPR_0;
            for (int i3 = 0; i3 < outPlaces.size(); ++i3) {
                place = outPlaces.elementAt(i3);
                expr = new VariableExpression(Types.UNTYPED, this.createPlaceVariable(variables, "out", place));
                arc = new Arc(place, transition, 1, (Expression)expr, ConstantExpression.doubleZeroExpression);
                arc.setTrace(shadowTransition.getTrace());
                transition.add((TransitionInscription)arc);
                RangeEnumeratorInscription range = new RangeEnumeratorInscription((Expression)expr, 0, 1, false, transition);
                transition.add((TransitionInscription)range);
                sum = new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{sum, expr}), (Function)BasicFunction.PLUS);
                CallExpression compareExpr2 = new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{expr, LOC_VAR_EXPR_ACT}), (Function)BasicFunction.LESSEQUAL);
                transition.add((TransitionInscription)new GuardInscription((Expression)compareExpr2));
            }
            CallExpression globalCompareExpr = new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{sum, LOC_VAR_EXPR_ACT}), (Function)BasicFunction.GREATEREQUAL);
            transition.add((TransitionInscription)new GuardInscription((Expression)globalCompareExpr));
        }
        if ("xor".equals(mode)) {
            VariableExpression choiceExpr = new VariableExpression(Types.UNTYPED, this.createAnonVariable());
            for (int i4 = 0; i4 < outPlaces.size(); ++i4) {
                place = outPlaces.elementAt(i4);
                Value iPlusOne = new Value((Object)(i4 + 1));
                Function & Serializable func = (Function & Serializable)arg -> {
                    if (iPlusOne.equals(arg)) {
                        return VALUE_1;
                    }
                    return VALUE_0;
                };
                Arc arc3 = new Arc(place, transition, 1, (Expression)new EqualsExpression(Types.UNTYPED, (Expression)new VariableExpression(Types.UNTYPED, this.createPlaceVariable(variables, "out", place)), (Expression)new CallExpression(Types.UNTYPED, (Expression)choiceExpr, (Function)func)), ConstantExpression.doubleZeroExpression);
                arc3.setTrace(shadowTransition.getTrace());
                transition.add((TransitionInscription)arc3);
            }
            RangeEnumeratorInscription range = new RangeEnumeratorInscription((Expression)choiceExpr, 0, outPlaces.size(), false, transition);
            transition.add((TransitionInscription)range);
            compareExpr = new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{LOC_VAR_EXPR_ACT, EXPR_0}), (Function)BasicFunction.EQUAL), new CallExpression(Types.UNTYPED, (Expression)new TupleExpression(new Expression[]{choiceExpr, EXPR_0}), (Function)BasicFunction.EQUAL)}), (Function)BasicFunction.EQUAL);
            transition.add((TransitionInscription)new GuardInscription((Expression)compareExpr));
        }
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        Net net = new Net(shadowNet.getName());
        for (Object elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowPlace)) continue;
            this.compile(net, (ShadowPlace)elem);
        }
        for (Object elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowTransition)) continue;
            this.compile(net, (ShadowTransition)elem);
        }
        this._lookup.setNet(shadowNet.getName(), net);
    }

    public String checkDeclarationNode(String inscr, boolean special, ShadowNet shadowNet) {
        return "unknown";
    }

    public String checkArcInscription(String inscr, boolean special, ShadowNet shadowNet) {
        return "unknown";
    }

    public String checkTransitionInscription(String inscr, boolean special, ShadowNet shadowNet) {
        return "unknown";
    }

    public String checkPlaceInscription(String inscr, boolean special, ShadowNet shadowNet) {
        return "unknown";
    }
}

