package de.renew.unify;

import java.util.Iterator;


public class TupleIterator implements Iterator<Object> {
    private Tuple tuple;
    private int index = 0;

    public TupleIterator(Tuple tuple) {
        this.tuple = tuple;
    }

    @Override
    public boolean hasNext() {
        return index < tuple.getArity();
    }

    @Override
    public Object next() {
        return tuple.getComponent(index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}