package de.renew.shadow;

public abstract class ShadowConnection extends ShadowInscribable {
    public boolean trace;
    public ShadowNode from;
    public ShadowNode to;

    protected ShadowConnection(ShadowNode from, ShadowNode to) {
        super(ensureIdentity(from, to));
        this.from = from;
        this.to = to;
        from.add(this);
        to.add(this);
    }

    private static ShadowNet ensureIdentity(ShadowNode from, ShadowNode to) {
        if ((from == null) | (to == null)) {
            throw new RuntimeException(
                            "Connection must be connected at both ends.");
        }

        //NOTICEnull
        ShadowNet net = from != null ? from.getNet() : null;
        if (to != null && net != to.getNet()) {
            throw new RuntimeException("Must connect within one net.");
        }
        return net;
    }

    public boolean getTrace() {
        return trace;
    }

    public void setTrace(boolean trace) {
        if (this.trace != trace) {
            this.trace = trace;
        }
    }

    @Override
    public void discard() {
        from.remove(this);
        to.remove(this);
        super.discard();
    }

    /**
     * Deserialization method, behaves like default readObject
     * method, additionally re-registers the connection at its nodes.
     **/
    private void readObject(java.io.ObjectInputStream in)
                    throws java.io.IOException, ClassNotFoundException {
        in.defaultReadObject();
        from.add(this);
        to.add(this);
    }
}