package de.renew.net.arc;

import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReserver;

import de.renew.unify.Variable;


public class InhibitorArcBinder extends ArcRemoveBinder {
    protected InhibitorArcBinder(Variable variable,
                                 SimulatablePlaceInstance placeInstance) {
        super(variable, placeInstance);
    }

    @Override
    protected boolean mayBind() {
        return true;
    }

    @Override
    protected boolean possible(TokenReserver reserver, Object token) {
        return !placeInstance.containsTestableToken(token);
    }

    @Override
    protected boolean remove(TokenReserver reserver, Object token) {
        return possible(reserver, token);
    }

    @Override
    protected void unremove(TokenReserver reserver, Object token) {
        // Nothing to do. No tokens are moved.
    }
}