package de.renew.engine.searcher;

import de.renew.engine.simulator.SimulationThreadPool;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;


// Recently added synchronisation. Will be necessary
// in concurrent environments. Should be covered by
// the place locking scheme, but let's not take any risks,
// because this might change.

/**
 * Primary implementation of {@link TriggerableCollection}.
 */
public class TriggerableCollectionImpl
                implements Serializable, TriggerableCollection {
    // Keep track of notified objects.
    private Set<Triggerable> triggerables;

    public TriggerableCollectionImpl() {
        assert SimulationThreadPool
                        .isSimulationThread() : "is not in a simulation thread";
        triggerables = new HashSet<Triggerable>();
    }

    @Override
    public synchronized void include(Triggerable triggerable) {
        assert SimulationThreadPool
                        .isSimulationThread() : "is not in a simulation thread";
        TriggerCollection triggers = triggerable.triggers();
        synchronized (triggers) {
            triggerables.add(triggerable);
            triggers.include(this);
        }
    }

    @Override
    public synchronized void exclude(Triggerable triggerable) {
        assert SimulationThreadPool
                        .isSimulationThread() : "is not in a simulation thread";
        TriggerCollection triggers = triggerable.triggers();
        synchronized (triggers) {
            triggerables.remove(triggerable);
            triggers.exclude(this);
        }
    }

    @Override
    public void proposeSearch() {
        assert SimulationThreadPool
                        .isSimulationThread() : "is not in a simulation thread";
        List<Triggerable> list = new ArrayList<Triggerable>();
        synchronized (this) {
            // Get the triggerables.
            list.addAll(triggerables);
        }


        // Send the notifications. No need to synchronize here.
        // Better allow concurrent accesses to reduce deadlock potential.
        // This way the triggerables can exclude themselves during the
        // notification.
        Iterator<Triggerable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Triggerable triggerable = iterator.next();
            triggerable.proposeSearch();
        }
    }
}