package de.renew.engine.searcher;


/**
 * Something that can be triggered in the triggering algorithm
 * by {@link #proposeSearch()}.
 * Currently implemented by {@link TransitionInstance} and
 * {@link SynchronisationRequest} within {@link de.renew}.
 * <p>
 * Also see the description of {@link TriggerableCollection}.
 **/
public interface Triggerable {

    /**
     * Return the set of all triggers.
     **/
    public TriggerCollection triggers();

    /**
     * Trigger a new search because bindings might have appeared of
     * disappeared.
     **/
    public void proposeSearch();
}