#!/bin/bash
#
# (This file was generated by PluginGenerator version 0.8.1)
# This script starts the Renew GUI and the application in this folder.
#
# Assumptions made by this script:
# - The java executables are included in the shell's search path.
# - All neccessary plugins are installed.
# - The variables below have been configured properly.
# - (A rmiregistry process has been started on the local host.)
#
# $Id$


# -------------------------------------------------------------------------
#                                                         PARSE COMMANDLINE
# -------------------------------------------------------------------------
customprops=()
debugeclipseoptions=()
jprofileoptions=()

while [ "X-" == `echo "X$1" | cut -c1-2` ]; do
    case "$1" in
    "-v"|"--verbose")
        verbose=true			# used in configuration section
        echo "OPTIONS: Verbose"
        shift
        ;;
    "-a"|"--ant")
        runant=true
	echo "OPTIONS: Run Ant first"
	shift
	;;
    "-r"|"--run")
        runscript=true
        echo "OPTIONS: run the startscript "
        shift
        ;;
    "-c"|"--centralDF")
        USECENTRALDF=true
        echo "OPTIONS: Use the CentralDF"
        shift
        ;;
    "-d"|"--debug-eclipse")
        debugeclipse=true		# used in configuration section
        echo "OPTIONS: debug-eclipse"
        shift
        ;;
    "-i"|"--custom-ip")
        customip=true
        echo "OPTIONS: custom set ip address"
        shift
        ;;
    "-k"|"--start-kbe")
        startkbe=true
        echo "OPTIONS: startkbe"
        shift
        ;;
    "-p"|"--profiler")
        runjprofiler=true		# used in configuration section
        echo "OPTIONS: profiler"
        shift
        ;;
    "-t"|"--host")
        echo "OPTIONS: Custom host name"
        shift
        customprops+=("-Dde.renew.agent.transport.capatcp.uri=x-capatcp://${1}:${2}")
        customprops+=("-Dde.renew.agent.transport.http.url=http://${1}:${3}")
        shift
        shift
        shift
        ;;
    "-h"|"--help")
        showhelp=true
        break
        ;;
    "-")
        break
        ;;
    *)
        echo "$0: unknown option: $1"
        showhelp=true
        break
        ;;
    esac
done

if [ "${showhelp}" = "true" ]
then
  echo "   This is the start.sh help message.";
  echo "   Start Application in folder AgentLola with "
  echo "    'bash testing/start.sh [options] [drawings...]'.";
  echo "   Options:";
  echo "    --verbose       -v  Be more verbose.";
  echo "    --ant           -a  Run 'ant dist' before starting the application.";
  echo "    --centralDF     -c  Sets the flag for usage of central-df.";
  echo "                        CentralDF AID is set in property de.renew.agent.platform.centralDF.";
  echo "                        Default is to tgi15 (set in Platform plugin.cfg).";
  echo "    --debug-eclipse -d  Start a debugging session with the remote debugger of eclipse.";
  echo "                        Further instructions will be given.";
  echo "    --custom-ip     -i  Set the ip address for the platform in VPN environment.";
  echo "                        USE ONLY on external (non RZ) machines.";
  echo "                        WORKS ONLY, if vpn connection is active.";
  echo "    --start-kbe     -k  Convenience option to start from the correct folder for KBE.";
  echo "    --profiler      -p  Start a profiling session with the remote profiling agent of JProfiler.";
  echo "    --host ip p q   -t ip p q   Allows to set a the hostname manually.";
  echo "                                The three arguments are obligatory. (Do not use together with -i.)"; 
  echo "                        ip       The host address (e.g. 127.0.0.1)"; 
  echo "                        p        The port for the capatcp transport service. "; 
  echo "                        q        The port for the http (jade) transport service. "; 
  echo "    -               -   End option processing, all following arguments are interpreted"
  echo "                        as drawing file names."
  echo "    --help          -h  Show this message.";
  exit 1;
fi


# -------------------------------------------------------------------------
#                                                     CONFIGURATION - BEGIN
# -------------------------------------------------------------------------


renewdist=$(dirname "$0")"/../../dist"

if [ "$verbose" = "true" ];then
  echo "Using Renew dist folder in $renewdist"
fi
capasrc=$(dirname "$0")"/../../../Mulan/Platform/src/de/renew/agent"
wgwsrc=$(dirname "$0")"/../../../Mulan/WebGateway/src/de/renew/agent/webgateway"
smsrc=$(dirname "$0")"/../../../Mulan/SubscriptionMonitor/src/de/renew/agent/subscriptionmonitor"
transportsrc=$(dirname "$0")"/../../../Mulan/PlatformTransportService/src/de/renew/agent"
mulanagentsrc=$(dirname "$0")"/../../../Mulan/MulanAgent/src/de/renew/agent"
pluginlocation=$(dirname "$0")"/.."
remotedcpluginlocation=$(dirname "$0")"/../../../Mulan/RemoteDC"
remotedc2pluginlocation=$(dirname "$0")"/../../../Mulan/RemoteDC2"
if [ "$verbose" = "true" ];then
  echo "Remote Dc = ${remotedcpluginlocation}"
  echo "Remote Dc = ${remotedc2pluginlocation}"
fi

# Location of the sample workflow net (change request)
# crlocation=../samples/changeRequest/

### RNRG Navigator options
navfilesoptions="-Dde.renew.navigator.filesAtStartup=RNRG/samples"


# As a result, the following options will set up the database
# connection:
#dboptions="-Dde.renew.simdb.driver=com.mysql.jdbc.Driver -Dde.renew.simdb.url=jdbc:mysql://localhost/${dbname} -Dde.renew.simdb.dialect=${dbdialect}"
dboptions=("-Dde.renew.simdb.driver=org.hsqldb.jdbcDriver" \
  "-Dde.renew.simdb.url=jdbc:hsqldb:file:${dbdirectory}/${dbname}" \
  "-Dde.renew.simdb.user=sa -Dde.renew.simdb.password=")

# If the workflow engine should read its configuration data from
# the database, too, we need to configure the database-specific
# adaptors. (Please ensure that the tables have been created in
# the database - you can use the .sql scripts in the ChangeRequestHandling
# directory.) !for further implementation!
# Alternatively, the workflow configuration data can be read from
# properties files in the changeRequestHandling directory. This is done
# through the ResourceBundleAdaptor. It has to be used, if no
# database connection has been set up.
adaptor=de.renew.workflow.DatabaseAdaptor
#adaptor=de.renew.workflow.ResourceBundleAdaptor

# if the commandline option --debug-eclipse is set augment options so that
# underlying Java VM is ready for debugging interaction with Eclipse
# (and every other program running on localhost)
# also see:  https://tgiprojekte.informatik.uni-hamburg.de/projects/paose/wiki/Eclipse#Remote-Debug-Modus-for-Java-Files

if [ "${debugeclipse}" = "true" ]
then
  debugeclipseoptions=("-Xdebug" "-Xnoagent" "-Djava.compiler=NONE" \
                       "-Xrunjdwp:transport=dt_socket,address=8787,server=y,suspend=y")
fi

# if the commandline option --jprofile is set augment options so that
# underlying Java VM is ready for profiling interaction with JProfiler
# (and every other program running on localhost)

if [ "${runjprofiler}" = "true" ]
then
  jprofileragentjar="${JPROFILER_HOME}/bin/agent.jar"
  if [ ! -f "${jprofileragentjar}" ]
  then
      echo "ERROR: Could not setup JProfiler: agent.jar not found."
      echo "       Please configure \$JPROFILER_HOME correctly."
      echo "       Was looking for: ${jprofileragentjar}"
      exit 1
  fi
  jprofileoptions=("-agentlib:jprofilerti=port=8786" \
                   "-Xbootclasspath/a:${jprofileragentjar}")
fi

UNAME=`uname |cut -d _ -f 1`

if [ "${customip}" = "true" ]
then
  if [ "Linux" = "$UNAME" ]; then
    ip=`/sbin/ifconfig -a | grep 134.100.4 | cut -b21-33 | sed -e 's/[ \t]*$//'`
  fi
  if [ "Darwin" = "$UNAME" ]; then
    ip=`/sbin/ifconfig -a | grep 134.100.4 | cut -d " " -f 2`
  fi
  if [ "CYGWIN" = "$UNAME" ]; then
    ip=`ipconfig | grep 134.100.4 | grep IP |cut -d : -f 2| cut -d " " -f 2 |sed -e 's/.$//'`
  fi
 
  echo "IP Address extracted from ifconfig: $ip"

  customprops+=("-Dde.renew.agent.transport.capatcp.uri=x-capatcp://${ip}:4711")
  customprops+=("-Dde.renew.agent.transport.http.url=http://${ip}:3297")
fi
if [ "$verbose" = "true" ]; then
  echo "customprops: ${customprops[@]}"
fi

if [ "${startkbe}" = "true" ]
then
  initialcommand="kbe"
  initialnet=""
else
  if [ "${runscript}" = "true" ]
  then
   initialcommand="script  $(dirname "$0")/startscript"
   initialnet=""
  else
  initialcommand="gui"
  initialnet="$(dirname "$0")/startCapa.rnw"
  fi
fi

# -------------------------------------------------------------------------
#                                                       CONFIGURATION - END
# -------------------------------------------------------------------------

# Run ant before anything else happens, if requested.
if [ "${runant}" == "true" ]
then
    pushd "${pluginlocation}"
    ant dist
    popd
fi

# If you are using the ResourceBundleAdaptor, you need to give
# the locations of access and workflow properties.
# propertyoptions=("-Dde.renew.access.properties=$accessproperties" "-Dde.renew.workflow.properties=$workflowproperties")

# path for automatic NETPATH generation or direct opening
pluginSourcePath="${pluginlocation}/src"

USEPSAGENT=false

# Reset database options if database is not used:
[ "${usedb}" == "yes" ] || dboptions=()

# Reset property options if resource bundle adaptor is not used:
[ "${adaptor}"=="de.renew.workflow.ResourceBundleAdaptor" ] || propertyoptions=()

# Setup the classpath: pluginSourcePath for workflow configuration, all Renew jars and the database
# connection, if needed. The Renew jars have to be included
# explicitly because the phoneshop and changeRequestHandling classes are not covered by the
# plugin class loader.
CLASSPATH="$pluginSourcePath"
CLASSPATH="$CLASSPATH:${renewdist}/loader.jar"

[ "${usedb}" == "yes" ] && CLASSPATH="${CLASSPATH}:${dbjarfile}"
export CLASSPATH

# Setup Plugin locations:
##PLUGINLOCATIONS=""

# Setup net load path: ChangeRequestHandling directory and Capa Nets are needed.
NETPATH="${pluginlocation}/net/paose/cap/agentlola:${capasrc}/platform:${smsrc}/interaction:${mulanagentsrc}/standard:${transportsrc}/transport:${capasrc}/transport/capatcp:${remotedcpluginlocation}/src/de/renew/agent/remoteDC/server:${remotedc2pluginlocation}/src/de/renew/agent/remoteDC2/server:${crlocation}:${wgwsrc}/interactions/agentlet:${wgwsrc}/interactions/webgateway:${wgwsrc}/interactions/registeragent:${wgwsrc}/roles/agentlet:${wgwsrc}/roles/webgateway"

# Extend net load path: AgentLola sources
NETPATH1=
NETPATH2=
NETDIRS=$(cd "${pluginSourcePath}"; find net/paose/cap/agentlola/interactions net/paose/cap/agentlola/roles -type d ! -name CVS \( -name .svn -prune -o -print \))

for dir in ${NETDIRS} ;
do
    NETPATH1="${NETPATH1}:CLASSPATH/${dir}"
    NETPATH2="${NETPATH2}:${pluginSourcePath}/${dir}"
done 
NETPATH="${NETPATH}:.${NETPATH1}${NETPATH2}"

if [ "$UNAME" = "CYGWIN" ]
then
    CLASSPATH=$(cygpath -wp "$CLASSPATH")
    NETPATH=$(cygpath -wp "$NETPATH")
    PLUGINLOCATIONS=$(cygpath -wp "$PLUGINLOCATIONS")
fi

# Print the configuration for debugging purposes
if [ "$verbose" = "true" ] ; then
echo
echo "CLASSPATH=${CLASSPATH}"
echo "NETPATH=${NETPATH}"
echo
echo "Workflow adaptor: ${adaptor}"
echo "Property options: ${propertyoptions[@]}"
echo "Custom set properties: ${customprops[@]}"
echo "Database options: ${dboptions[@]}"
echo "Eclipse Debug options: ${debugeclipseoptions[@]}"
echo "JProfiler options: ${jprofileoptions[@]}"
fi

# Print hint for poor user trying to debug
if [ "${debugeclipse}" = "true" ]
then
    echo
    echo
    echo
    echo "You are about to start Renew (the Java VM to be more precise) with remote DEBUG settings."
    echo
    echo
    echo "RENEW WILL *NOT* CONTINUE UNLESS YOU CONNECT YOUR ECLIPSE TO IT."
    echo
    echo
    echo "For the gory details please see:"
    echo "  https://tgiprojekte.informatik.uni-hamburg.de/projects/paose/wiki/Eclipse#Remote-Debug-Modus-for-Java-Files"
    echo
fi

# Print hint for poor user trying to profile
if [ "${runjprofiler}" = "true" ]
then
    echo
    echo
    echo
    echo "You are about to start Renew (the Java VM to be more precise) with remote"
    echo "PROFILING settings."
    echo
    echo
    echo "RENEW WILL *NOT* CONTINUE UNLESS YOU CONNECT YOUR JPROFILER TO IT."
    echo
    echo
    echo "Note: To allow the profiling agent to run, you need to configure your"
    echo "OS-specific dynamic library path setting.  Hopefully you did that already,"
    echo "otherwise the execution will probably fail."
    echo "  Windows: Add to PATH environment variable either"
    echo "           ${JPROFILER_HOME}/bin/windows (32-bit) or"
    echo "           ${JPROFILER_HOME}/bin/windows-x64 (64-bit)."
    echo "  Linux:   Add to LD_LIBRARY_PATH environment variable either"
    echo "           ${JPROFILER_HOME}/bin/linux-x86 (32-bit) or"
    echo "           ${JPROFILER_HOME}/bin/linux-x64 (64-bit)."
    echo "  Solaris: Add to LD_LIBRARY_PATH environment variable either"
    echo "           ${JPROFILER_HOME}/bin/solaris-sparc (32-bit) or"
    echo "           ${JPROFILER_HOME}/bin/solaris-sparcv9 (64-bit)."
    echo "  MacOS X: Add to DYLD_LIBRARY_PATH environment variable"
    echo "           ${JPROFILER_HOME}/bin/macos ."
    echo
fi


# Start Renew
echo "Starting Renew..."
[ "$verbose" = "true" ] && set -x
"${JAVA_HOME}/bin/java" "${debugeclipseoptions[@]}" "${dboptions[@]}" "${propertyoptions[@]}" \
    "${jprofileoptions[@]}" \
    "${customprops[@]}" \
    "-Dde.renew.access.adaptor=${adaptor}" \
    "-Dde.renew.remote.enable=true" \
    "-DpluginLocations=${PLUGINLOCATIONS}" \
    "-Dde.renew.agent.platform.useCentralDF=${USECENTRALDF}" \
    "-Dde.renew.agent.ace.start-agent.ps=${USEPSAGENT}" \
    "-Dde.renew.netPath=${NETPATH}" \
    "${navwsoptions}" \
    "${navfilesoptions}" \
    ${JAVA_OPTS} \
    de.renew.plugin.Loader "${initialcommand}" \
        "${initialnet}" \
        "$@"
