package de.renew.rnrg.gui;

import CH.ifa.draw.figures.TextFigure;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.ParentFigure;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;

import java.awt.Color;

import java.io.IOException;


public class Inscription extends TextFigure {
    String textA;
    String textB;
    boolean toggle;

    /**
     * For loading as a Storable.
     */
    public Inscription() {
    }

    public Inscription(String textA, String textB, boolean toggle,
                       ParentFigure parent) {
        this.textA = textA;
        this.textB = textB;
        this.toggle = toggle;

        setFillColor(Color.WHITE);
        initialize(parent);
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        if (!alternate) {
            return super.inspect(view, alternate);
        } else {
            toggle = !toggle;

            resetText();

            return true;
        }
    }

    private void resetText() {
        if (toggle) {
            setText(textB);
        } else {
            setText(textA);
        }
    }

    @Override
    public boolean canBeParent(ParentFigure parent) {
        // The parent can only be set once.
        return parent() == null && super.canBeParent(parent);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(parent());
        dw.writeString(textA);
        dw.writeString(textB);
        dw.writeBoolean(toggle);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        ParentFigure parent = (ParentFigure) dr.readStorable();
        textA = dr.readString();
        textB = dr.readString();
        toggle = dr.readBoolean();

        initialize(parent);
    }

    private void initialize(ParentFigure parent) {
        setParent(parent);
        // Inform inscription of changes to parent.
        parent.addToContainer(this);

        resetText();
    }
}