package de.renew.rnrg.gui;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.LineConnection;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;

import CH.ifa.draw.standard.StandardDrawing;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;

import de.renew.gui.AnnealingGraphLayout;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;

import de.renew.rnrg.elements.Edge;
import de.renew.rnrg.elements.Graph;
import de.renew.rnrg.elements.InscribedEdge;
import de.renew.rnrg.elements.Node;

import java.awt.Color;

import java.io.IOException;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;


public class GraphDrawing extends StandardDrawing implements LayoutableDrawing {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(GraphDrawing.class);
    private static final long serialVersionUID = 0L;
    private static final int CONNECTION_LENGTH = 90;
    public final static int INSC_NOTHING = 0;
    public final static int INSC_ROOT = 1;
    public final static int INSC_ALL = 2;
    public final static int INSC_DEPTH = 3;
    public final static String[] INSC_MODES = { "Nothing", "State of Root Net Instance", "State of all Net Instances", "Depth" };

    /**
     * For loading as a {@link Storable}.
     */
    public GraphDrawing() {
    }

    public GraphDrawing(Graph graph, int inscMode) {
        this(graph.getNodes(), graph.getStartNode(), inscMode);
    }

    public GraphDrawing(final Collection<Node> nodes, final Node startNode,
                        int inscMode) {
        Map<Node, AttributeFigure> nodeFigures = new HashMap<Node, AttributeFigure>();
        for (Node node : nodes) {
            addExploredFigure(node, nodeFigures, inscMode);
        }

        for (Node node : nodes) {
            addEdges(node, nodeFigures);
        }

        nodeFigures.get(startNode).setFillColor(Color.RED);

        (new AnnealingGraphLayout()).annealingLayout(this);
    }

    private void addExploredFigure(Node node,
                                   Map<Node, AttributeFigure> nodeFigures,
                                   int inscMode) {
        ExploredNodeFigure nodeFig = new ExploredNodeFigure(node);
        nodeFigures.put(node, nodeFig);
        add(nodeFig);

        if (inscMode != INSC_NOTHING) {
            add(nodeFig.createTextFigure(inscMode));
        }
    }

    private AttributeFigure addUnexploredFigure() {
        AttributeFigure nodeFig = new UnexploredNodeFigure();
        add(nodeFig);

        return nodeFig;
    }

    private void addEdges(Node node, Map<Node, AttributeFigure> nodeFigures) {
        Collection<Edge> edges = node.getEdges();
        for (Edge edge : edges) {
            Node targetNode = edge.getTargetNode();
            AttributeFigure nextFig;
            if (targetNode == null) {
                // unexplorable
                nextFig = addUnexploredFigure();
            } else {
                // explorable
                nextFig = nodeFigures.get(targetNode);
            }

            connect(nodeFigures.get(node), nextFig, edge);
        }
    }

    private void connect(AttributeFigure start, AttributeFigure end,
                         Edge edge) {
        // Create the connection from start to end.
        LineConnection connection = new LineConnection(null, new ArrowTip(),
                        "");
        connection.startPoint(0, 0);
        connection.endPoint(0, 0);
        connection.connectStart(start.connectorAt(start.center()));
        connection.connectEnd(end.connectorAt(end.center()));
        connection.updateConnection();

        // Add the connection to the displayed figures.
        add(connection);

        if (edge instanceof InscribedEdge) {
            // Create inscription with the given text at the center of the connection.
            EdgeInscription edgeInscription = new EdgeInscription(
                            (InscribedEdge) edge, connection);
            // Add the inscription to the displayed figures.
            add(edgeInscription);
        }
    }

    @Override
    synchronized public void fillInGraph(GraphLayout layout) {
        FigureEnumeration k = figures();

        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();

            if (f instanceof ExploredNodeFigure
                            || f instanceof UnexploredNodeFigure) {
                layout.addNode(f);
            } else if (f instanceof ConnectionFigure) {
                layout.addEdge((ConnectionFigure) f, CONNECTION_LENGTH);
            }
        }
    }

    /**
     * Reads the contained figures from StorableInput.
     * <p>
     * For graph drawings generated by this version of the code
     * {@link StandardDrawing#read(StorableInput)} would suffice,
     * but for backward compatibility this method is still needed.
     */
    @Override
    public void read(StorableInput dr) throws IOException {
        int size = dr.readInt();
        fFigures = new Vector<Figure>(size);
        for (int i = 0; i < size; i++) {
            try {
                final Figure f = (Figure) dr.readStorable();

                // This is needed for backward compatibility.
                if (f instanceof EdgeInscription) {
                    final Figure parent = ((EdgeInscription) f).parent();
                    if (!fFigures.contains(parent)) {
                        add(parent);
                        i++;
                    }
                }

                add(f);
            } catch (IOException e) {
                final String desc = GraphDrawing.class.getSimpleName()
                                + ": could not read in "
                                + Figure.class.getSimpleName() + " object:";
                if (logger.isDebugEnabled()) {
                    // long version
                    logger.error(desc, e);
                } else {
                    // short version
                    logger.error(desc + " " + e);
                }
                break;
            }
        }
    }
}