package de.renew.rnrg.elements;

import de.renew.net.NetInstance;

import java.io.Serializable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;


public abstract class Node implements Serializable {
    private static final long serialVersionUID = 9208206770140563018L;
    transient Collection<Edge> edges; // null until exploreEdges method is called.  Do not persist.
    transient Set<Node> predecessors; // null until the first predecessor is added. Do not persist.

    public Collection<Edge> getEdges() {
        return edges;
    }

    public Set<Node> getPredecessors() {
        if (predecessors == null) {
            return Collections.emptySet();
        }
        return predecessors;
    }

    public void addPredecessor(Node node) {
        if (predecessors == null) {
            predecessors = new HashSet<Node>();
        }
        predecessors.add(node);
    }

    public abstract Collection<? extends NetInstance> getNetInstances();

    public abstract NetInstance getRootNetInstance();

    public abstract long getDepth();
}