package de.renew.rnrg.elements;

import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.ResettableNetInstance;

import de.renew.unify.Impossible;

import java.io.Serializable;

import java.util.HashMap;


/**
 * Encapsulates a resettable net instance so that two instances with the same contents are equal.
 *
 * @author Michael Simon
 *
 */
public class NetInstanceState implements Serializable {
    private static final long serialVersionUID = 0L;
    final ResettableNetInstance instance;
    private final int hashCode; // Caches the hash code.

    public NetInstanceState(final ResettableNetInstance instance) {
        this.instance = instance;
        hashCode = instance.stateHashCode();
    }

    public NetInstanceState(final Net net) {
        try {
            instance = new ResettableNetInstance(net, true);
        } catch (Impossible e) {
            throw new RuntimeException(e);
        }
        hashCode = instance.stateHashCode();
    }

    public NetInstance getNetInstance() {
        return instance;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof NetInstanceState) && instance.stateEquals(
                        ((NetInstanceState) obj).instance,
                        new HashMap<ResettableNetInstance, ResettableNetInstance>());
    }

    @Override
    public String toString() {
        return instance.toString();
    }
}