package de.renew.rnrg.elements;

import de.renew.engine.simulator.GraphFinder.TransitionChecker;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;


public class Graph {
    public interface Aborter {
        public boolean abort();
    }

    /**
     * Maps a root net instance state to its node.
     * <p>
     * Once one node for a specific state is found, it is added to the map.
     * If the state is found again, this original node is retrieved from the map,
     * so that all edges get added to it. It has to be a map and not a set
     * for the retrieval of the original node of a specific state to be possible.
     */
    private Map<NetInstanceState, Node> nodes = new HashMap<NetInstanceState, Node>();
    final private Node startNode;
    private boolean maxDepthReached = false;

    /**
     * Create the graph by a breadth-first search.
     *
     * @param maxDepth is the maximum depth to explore
     * @param checker decides which transitions are explored
     */
    public Graph(NodeImpl startNode, long maxDepth, TransitionChecker checker,
                 Aborter aborter) {
        this.startNode = startNode;

        Queue<NodeImpl> queue = new LinkedList<NodeImpl>();
        NodeImpl node = startNode;
        startNode.addTo(nodes);
        while (node != null && !aborter.abort()) {
            boolean maxDepthReached = node.exploreEdges(maxDepth, checker,
                            nodes, queue);
            this.maxDepthReached |= maxDepthReached;
            node = queue.poll();
        }
    }

    public Node getStartNode() {
        return startNode;
    }

    public Collection<Node> getNodes() {
        return nodes.values();
    }

    public boolean isMaxDepthReached() {
        return maxDepthReached;
    }
}