package de.renew.rnrg;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.MenuManager;

import CH.ifa.draw.util.CommandMenuItem;

import de.renew.gui.GuiPlugin;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;

import de.renew.rnrg.commands.ReachabilityGraphClCommand;
import de.renew.rnrg.commands.ReachabilityGraphCommand;

import java.net.URL;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version 0.3)
 * Representative for the RNRG (Reference Net Reachability Graph) plugin.
 *
 * @author PluginGenerator
 */
public class RNRGPlugin extends PluginAdapter {
    private final CommandMenuItem _menuItem = new CommandMenuItem(
                    new ReachabilityGraphCommand());

    public RNRGPlugin(URL url) throws PluginException {
        super(url);
    }

    public RNRGPlugin(PluginProperties props) {
        super(props);
    }

    /** Initialize the plugin, register menues and commands.
     * @see de.renew.plugin.PluginAdapter#init()
     */
    @Override
    public void init() {
        DrawPlugin gui = DrawPlugin.getCurrent();
        if (gui != null) {
            MenuManager menuManager = gui.getMenuManager();

            if (PluginProperties.getUserProperties().getBoolProperty(
                            GuiPlugin.USE_VERIFICATION_MENU_PROP_NAME, false)) {
                menuManager.registerMenu(GuiPlugin.VERIFICATION_MENU, _menuItem,
                                "de.renew.rnrg");
            } else {
                menuManager.registerMenu(DrawPlugin.TOOLS_MENU, _menuItem,
                                "de.renew.rnrg");
            }
        }

        PluginManager.getInstance().addCLCommand(ReachabilityGraphClCommand.CMD,
                        new ReachabilityGraphClCommand());
        super.init();
    }

    /** Deinitialize plugin.
     * @see de.renew.plugin.PluginAdapter#cleanup()
     */
    @Override
    public boolean cleanup() {
        DrawPlugin gui = DrawPlugin.getCurrent();
        if (gui != null) {
            gui.getMenuManager().unregisterMenu(_menuItem);
        }
        PluginManager.getInstance()
                        .removeCLCommand(ReachabilityGraphClCommand.CMD);
        return super.cleanup();
    }
}