package de.renew.net;

import de.renew.engine.simulator.GraphFinder.TransitionChecker;

import de.renew.net.inscription.ActionInscription;
import de.renew.net.inscription.CreationInscription;


public class TransitionCheckerImpl implements TransitionChecker {
    private final boolean action;
    private final boolean creation;

    public TransitionCheckerImpl(boolean action, boolean creation) {
        this.action = action;
        this.creation = creation;
    }

    @Override
    public boolean isExplorable(Transition trans) {
        if (action || creation) {
            for (TransitionInscription insc : trans.inscriptions) {
                if ((action && insc instanceof ActionInscription) || (creation
                                && insc instanceof CreationInscription)) {
                    return false;
                }
            }
        }
        return true;
    }
}