package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.net.Transition;
import de.renew.net.TransitionOccurrence;

import java.util.ArrayList;
import java.util.Collection;


public class GraphFinder implements Finder {
    public interface TransitionChecker {
        public boolean isExplorable(Transition trans);
    }

    private final TransitionChecker checker;
    private Collection<Binding> explorableBindings = new ArrayList<Binding>();
    private Collection<Binding> unexplorableBindings = new ArrayList<Binding>();

    public GraphFinder(TransitionChecker checker) {
        this.checker = checker;
    }

    /**
     * Sort found bindings into explorable and unexplorable.
     */
    @Override
    public void found(Searcher searcher) {
        for (Occurrence occ : searcher.getOccurrences()) {
            if (occ instanceof TransitionOccurrence && !checker
                            .isExplorable(((TransitionOccurrence) occ)
                                            .getTransition().getTransition())) {
                unexplorableBindings.add(new Binding(searcher));
                return;
            }
        }

        explorableBindings.add(new Binding(searcher));
    }

    // I will never be satisfied with the bindings that I have collected.
    @Override
    public boolean isCompleted() {
        return false;
    }

    public Collection<Binding> explorableBindings() {
        return explorableBindings;
    }

    public Collection<Binding> unexplorableBindings() {
        return unexplorableBindings;
    }
}