package de.renew.call;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.EarlyExecutable;

import de.renew.unify.Impossible;


class BlockExecutable implements EarlyExecutable {
    SynchronisationRequest synchronisation;

    BlockExecutable(SynchronisationRequest synchronisation) {
        this.synchronisation = synchronisation;
    }

    @Override
    public int phase() {
        return BLOCK;
    }

    @Override
    public long lockPriority() {
        return synchronisation.lockOrder;
    }

    /**
     * Locks the <code>SynchronisationRequest</code> associated with this arc.
     * @see SynchronisationRequest#lock
     **/
    @Override
    public void lock() {
        synchronisation.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        if (synchronisation.completed) {
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        synchronisation.completed = true;
    }

    @Override
    public void rollback() {
        // Nothing to do.
    }

    /**
     * Unlocks the <code>SynchronisationRequest</code> associated with this arc.
     * @see SynchronisationRequest#lock
     **/
    @Override
    public void unlock() {
        synchronisation.lock.unlock();
    }
}