/**
 *
 */
package de.renew.lola2.gui;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.DrawApplication;

import de.renew.gui.CPNDrawing;
import de.renew.lola2.commands.CheckAllCommand;

import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;

import javax.swing.JFrame;
import javax.swing.JTabbedPane;


/**
 * @author hewelt, mosteller
 * @date 16.08.2012
 */
public class LolaGUI extends JFrame {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CheckAllCommand.class);
    String lolaPath = "";


    /**
     * The panels used for the tabs
     */
    private TasksPanel _generalPanel;
    private ChecklistPanel _checkListPanel;
    private MarkingEditorPanel _markEdPanel;

    /**
     * The drawing being analyzed at the moment
     */
    CPNDrawing drawing;


    /**
     * @throws HeadlessException
     */
    public LolaGUI() throws HeadlessException {
        init();
    }

    /**
     * @param gc
     */
    public LolaGUI(GraphicsConfiguration gc) {
        super(gc);
        init();
    }

    /**
     * @param title
     * @throws HeadlessException
     */
    public LolaGUI(String title) throws HeadlessException {
        super(title);
        init();
    }

    /**
     * @param title
     * @param gc
     */
    public LolaGUI(String title, GraphicsConfiguration gc) {
        super(title, gc);
        init();
    }

    public LolaGUI(String title, String path) {
        super(title);
        lolaPath = path;
        init();
    }

    /**
     * Init the 3 tabs by running their individual setup methods.
     */
    public void init() {
        DrawApplication app = DrawPlugin.getGui();

        // current drawing needs to be a CPNDrawing
        if (app.drawing() instanceof CPNDrawing) {
            drawing = (CPNDrawing) app.drawing();
            JTabbedPane tabs = new JTabbedPane();
            _generalPanel = new TasksPanel(this);
            _checkListPanel = new ChecklistPanel(this);
            _markEdPanel = new MarkingEditorPanel(this);
            //tabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
            tabs.addTab("Checklist", _checkListPanel);
            tabs.addTab("Marking Editor", _markEdPanel);
            tabs.addTab("Tasks", _generalPanel);
            this.add(tabs, BorderLayout.CENTER);
            // now check
            checkNow();
        } else {
            logger.error("[Lola GUI] Could not initialize, no open CPNDrawing.");
        }
    }

    /**
     * This runs the checks in the Checklist and
     * fills the table of the marking editor.
     */
    public void checkNow() {
        _checkListPanel.updateChecklist();
        _markEdPanel.updatePlaces();
    }
}