package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.DrawApplication;

import CH.ifa.draw.framework.Figure;

import CH.ifa.draw.util.Command;

import de.renew.gui.CPNDrawing;
import de.renew.gui.TransitionFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;

import java.awt.Color;

import java.io.File;
import java.io.PrintStream;

import java.util.Vector;


public class CheckSelectedTransitionCommand extends Command
                implements CLCommand {
    private String lolaPath;
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CheckSelectedTransitionCommand.class);

    public CheckSelectedTransitionCommand(String name, String path) {
        super(name);
        lolaPath = path;
    }

    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing) app.drawing();
        // enable undo
        app.getUndoRedoManager().prepareUndoSnapshot(app.drawing());


        // get selected figures
        Vector<Figure> selection = app.view().selection();
        PropertyAnalyzer analyzer = new PropertyAnalyzer(lolaPath);

        // Write lola File
        LolaFileCreator creator = new LolaFileCreator();
        File netFile = creator.writeTemporaryLolaFile(drawing);
        if (logger.isDebugEnabled()) {
            logger.debug(CheckAllCommand.class.getSimpleName()
                            + ": temp file name: " + netFile.getPath());
        }

        for (Figure fig : selection) {
            if (fig instanceof TransitionFigure) {
                String transitionName = creator.getNameForFigure(fig);
                DirectLolaResult result = analyzer.checkTransitionLiveness(transitionName, netFile);
                if (result != null) {
                    switch (result.getStatus()) {
                    case YES:
                        LolaGUIHelper.colorFigure(fig, Color.GREEN);
                        break;
                    case NO:
                        LolaGUIHelper.colorFigure(fig, Color.RED);
                        break;
                    default:
                        break;
                    }
                }
            }
        }

        app.getUndoRedoManager().commitUndoSnapshot(app.drawing());
    }

    @Override
    public void execute(String[] args, PrintStream response) {
        //TODO: implement the check from console
    }

    @Override
    public String getDescription() {
        return "Check if the selected transition is dead";
    }
}