package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.DrawApplication;

import CH.ifa.draw.util.Command;

import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;

import java.io.File;


public class CheckLivenessCommand extends Command {
    private String lolaPath;
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CheckLivenessCommand.class);

    public CheckLivenessCommand(String name, String path) {
        super(name);
        lolaPath = path;
    }

    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing) app.drawing();
        PropertyAnalyzer analyzer = new PropertyAnalyzer(lolaPath);

        // Write lola File
        File netFile = new LolaFileCreator().writeTemporaryLolaFile(drawing);
        if (logger.isDebugEnabled()) {
            logger.debug(CheckAllCommand.class.getSimpleName()
                            + ": temp file name: " + netFile.getPath());
        }

        LolaResult result = analyzer.checkNetLiveness(netFile, true);
        switch (result.getStatus()) {
        case YES:
            logger.info("YES, net is live.");
            break;
        case NO:
            logger.info("NO, net is not live.");
            break;
        default:
            logger.info("Unspecified result for liveness: "
                            + result.getStatus());
        }
    }
}