package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.DrawApplication;

import CH.ifa.draw.figures.TextFigure;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;

import CH.ifa.draw.util.Command;

import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.plugin.command.CLCommand;

import java.io.PrintStream;


/**
 * Checks a selected verification request with Lola and colors the
 * TextFigure of the request depending on the result.
 *
 * @author hewelt
 *
 */
public class CheckAllTasksCommand extends Command implements CLCommand {
    private String lolaPath;
    
    public CheckAllTasksCommand(String name, String path) {
        super(name);
        this.lolaPath = path;
    }

    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(CheckVerificationRequestCommand.class);

    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        Drawing drawing = app.drawing();

        app.getUndoRedoManager().prepareUndoSnapshot(drawing);

        if (!(drawing instanceof CPNDrawing)) {
            logger.error("[Lola] Drawing needs to be a CPNDrawing. Aborting.");
            return;
        }

        FigureEnumeration figures = drawing.figures();

        // create lola file
        Boolean changed = false;
        while (figures.hasMoreElements()) {
            Figure fig = figures.nextElement();
            if (fig instanceof TextFigure) {
                TextFigure textFig = (TextFigure) fig;
                String text = textFig.getText();
                if (text.toLowerCase().startsWith("formula")) {
                    LolaTask task = new LolaTask((TextFigure) fig,
                                    (CPNDrawing) drawing);
                    task.check(new LolaAnalyzer(lolaPath));
                    task.colorFigure();
                    fig.changed();
                    changed = true;
                }
            } else { // if we are not a TextFigure
                logger.info("[Lola] Currently only checking TextFigures.");
            }
        }
        if (changed) {
            DrawPlugin.getGui().view().checkDamage();
            app.getUndoRedoManager().commitUndoSnapshot(drawing);
        }
    }

    @Override
    public void execute(String[] args, PrintStream response) {
        // TODO Auto-generated method stub
    }

    @Override
    public String getDescription() {
        // TODO Auto-generated method stub
        return null;
    }
}