package de.renew.lola2.analysis;

public enum LolaResultStatus {
    YES, NO, ERROR, UNCHECKED, INFEASIBLE;
    public static LolaResultStatus composeStatiConjunctive(LolaResultStatus status1,
                                                           LolaResultStatus status2) {
        // conjunctive compositions (symmetric)
        //
        //            | YES        | NO         | ERROR      | UNCHECKED  | INFEASIBLE
        // ----------------------------------------------------------------------------
        // YES        | YES        | NO         | ERROR      | UNCHECKED  | INFEASIBLE
        // NO         |            | NO         | NO         | NO         | NO
        // ERROR      |            |            | ERROR      | ERROR      | INFEASIBLE
        // UNCHECKED  |            |            |            | UNCHECKED  | INFEASIBLE
        // INFEASIBLE |            |            |            |            | INFEASIBLE     
        LolaResultStatus result;

        if (status1 == YES) {
            result = status2;
        } else if (status2 == YES) {
            result = status1;
        } else if (status1 == NO || status2 == NO) {
            result = NO;
        } else if (status1 == ERROR || status2 == ERROR) {
            if (status1 == INFEASIBLE || status2 == INFEASIBLE) {
                result = INFEASIBLE;
            } else {
                result = ERROR;
            }
        } else if (status1 == UNCHECKED && status2 == UNCHECKED) {
            result = UNCHECKED;
        } else if (status1 == INFEASIBLE && status2 == INFEASIBLE) {
            result = INFEASIBLE;
        } else {
            // this should never happen
            result = ERROR;
        }

        return result;
    }

    public static LolaResultStatus inverse(LolaResultStatus status) {
        LolaResultStatus result;
        if (status == YES) {
            result = NO;
        } else if (status == NO) {
            result = YES;
        } else {
            result = status;
        }
        return result;
    }
}