package de.renew.lola2.analysis;

import de.renew.plugin.PluginProperties;

import java.io.File;


/**
 * Defines constants used in the context of lola.
 * @author hewelt
 *
 */
public class LolaHelper {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(LolaHelper.class);

    /*
     * name of lola binaries ("commands") for the specific tasks.
     */
    public static final String lolaCommand = "lola";

    //    public static final String dotCommand = "graph2dot";
    //    public static final String graphCommand = "lola -M";
    //    public static final String nethomeStateCommand = "lola-home-state";

    /**
     * Determine the temporary directory to use.
         * @return dir
         *
         */
    public static File findTmpDir() {
        String tmp = PluginProperties.getUserProperties()
                        .getProperty("de.renew.lola.tmpdir");
        File dir;
        if (tmp != null) {
            dir = new File(tmp);
        } else {
            tmp = System.getProperty("java.io.tmpdir");
            if (tmp != null) {
                dir = new File(tmp);
            } else {
                logger.error("System property java.io.tmpdir not found, please provide de.renew.lola.tmpdir in your user properties");
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Lola] tmpDir successfully set");
        }
        return dir;
    }
}