package de.renew.lola2.analysis;

import java.util.Optional;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;


public class DirectLolaResult implements LolaResult {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(DirectLolaResult.class);
    private String output;
    private String error;
    private LolaResultStatus status;

    public DirectLolaResult(int returnValue, String output, String error) {
        this.output = output;
        this.error = error;
        this.status = checkResultStatus(returnValue, output);
    }

    private LolaResultStatus checkResultStatus(int returnValue, String output) {
        LolaResultStatus status = null;

        if (returnValue == 0) {
            // the LoLA JSON result should be in format:
            // {
            //     "analysis": {
            //         "result": true/false,
            //         ...
            //     },
            //     ...
            // }
            JSONParser parser = new JSONParser();
            try {
                Optional<Boolean> result = Optional.of(parser.parse(output)).filter(JSONObject.class::isInstance).map(JSONObject.class::cast)
                                .filter(o -> o.containsKey("analysis")).map(o -> o.get("analysis"))
                                .filter(JSONObject.class::isInstance).map(JSONObject.class::cast)
                                .filter(o -> o.containsKey("result")).map(o -> o.get("result"))
                                .filter(Boolean.class::isInstance).map(Boolean.class::cast);
                if (result.isPresent()) {
                    status = result.get() ? LolaResultStatus.YES : LolaResultStatus.NO;
                } else {
                    status = LolaResultStatus.ERROR;
                    logger.error("Could not extract LoLA result from JSON output.");
                }
                
            } catch (ParseException e) {
                status = LolaResultStatus.ERROR;
                logger.error("Could not parse LoLA JSON output.");
            }
        } else {
            status = LolaResultStatus.ERROR;
            logger.error("LoLA call returned an error.");
        }
        return status;
    }

    public String getOutput() {
        return this.output;
    }
    
    public String getError() {
        return this.error;
    }

    @Override
    public LolaResultStatus getStatus() {
        return this.status;
    }
}