#!/bin/bash

TAR=tar

echo `uname`

if [ `uname` = "SunOS" ]
then
echo "On SunOs using gtar instead of tar."
TAR=gtar
fi

if [ `uname` = "Darwin" ]
then
echo "On MacOS using tar."
fi


# create lib folder if it doesn't exist
if [ ! -d lib ];
then
   mkdir lib
fi

# download lola version 2.0 if it doesn't exist
VERSION=2.0.b
if [ -e lola-${VERSION} ];
then
    echo "Lola 2.0 source directory exists, continuing..."
else 
  wget https://git.informatik.uni-hamburg.de/tgipublic/lola/lola/-/archive/${VERSION}/lola-${VERSION}.tar.gz
  echo "lola location unreachable"
  $TAR zxf lola-${VERSION}.tar.gz
fi

# build lola (full) in version 2.0
LOLADIR=lola-${VERSION}
echo Directory is ${LOLADIR}
if [ -e "lib/lola" -a "`lib/lola -V | head -n1`" = "LoLA 2.0" ];
then 
    echo "========================================================"
    echo "Correct version ${VERSION} of lola (full) binary exists; skipping"
else
    echo "========================================================"
    echo "Wrong or no version of lola (full) binary detected; compiling"

    cd ${LOLADIR}
    ./configure
    make clean
    make
    cp src/lola ../lib/lola
    cp COPYING ../lib/lola-LICENSE.txt
fi
