package de.renew.lola;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;

import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ImportHolder;

import CH.ifa.draw.util.CommandMenu;

import de.renew.gui.GuiPlugin;

import de.renew.io.exportFormats.LolaExportFormat;
import de.renew.io.importFormats.LolaImportFormat;

import de.renew.lola.commands.CheckAllCommand;
import de.renew.lola.commands.CheckAllTasksCommand;
import de.renew.lola.commands.CheckLivenessCommand;
import de.renew.lola.commands.CheckSelectedPlaceCommand;
import de.renew.lola.commands.CheckSelectedTransitionCommand;
import de.renew.lola.commands.CheckVerificationRequestCommand;
import de.renew.lola.commands.OpenLolaGUICommand;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;

import java.awt.event.KeyEvent;

import java.io.UnsupportedEncodingException;

import java.net.URL;
import java.net.URLDecoder;

import java.util.Iterator;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version ${pd.version})
 * Representative for the Lola plug-in.
 *
 * @author PluginGenerator
 */
public class LolaPlugin extends PluginAdapter {
    //private StringBuffer lolaimages;
    private CommandMenu _menu;
    private static StringBuffer lolaPath = new StringBuffer();
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(LolaPlugin.class);

    //private File tmpDir = null;
    public LolaPlugin(URL url) throws PluginException {
        super(url);
        //    registerClasses();
    }

    public LolaPlugin(PluginProperties props) {
        super(props);
        //    registerClasses();
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.PluginAdapter#cleanup()
     */
    @Override
    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }

        MenuManager mm = current.getMenuManager();

        if (mm != null && _menu != null) {
            mm.unregisterMenu(_menu);
        }
        return true;
    }

    /*
     * (non-Javadoc)
     *
     * @see de.renew.plugin.PluginAdapter#getAlias()
     */
    @Override
    public String getAlias() {
        return "lola";
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.PluginAdapter#init()
     */
    @Override
    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent(); //needed for "Extras/Lola Integration" menu

        //        lolaimages.append(mylocation.substring(0, mylocation.lastIndexOf("dist")));
        //        lolaimages.append("Lola"+separator);

        //        CPNTextTool tool = new CPNTextTool(drawingEditor, new DeclarationFigure(), false);
        //        String imgFile = lolaimages.toString() + "LDECL.gif";
        //        logger.info("Toolbutton image is: "+imgFile);
        //        ToolButton fDeclTB = ((DrawApplication) drawingEditor).createToolButton(imgFile, "Lola Declaration Tool", tool);
        //        Palette palette =  new Palette(menuFrame, "Lola Tools");
        //		palette.add(fDeclTB);
        //		
        //        ((DrawApplication) drawingEditor).getToolsPanel().add(palette.getComponent());
        ExportHolder exportHolder = DrawPlugin.getCurrent().getExportHolder();
        exportHolder.addExportFormat(new LolaExportFormat());
        ImportHolder importHolder = DrawPlugin.getCurrent().getImportHolder();
        importHolder.addImportFormat(new LolaImportFormat());

        if (current == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Lola] Plugin Name: " + _properties.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Lola] Plugin Location: " + _properties.getURL());
        }

        String mylocation = _properties.getURL().getPath();
        try {
            mylocation = URLDecoder.decode(_properties.getURL().getPath(),
                            "UTF-8");
        } catch (UnsupportedEncodingException e1) {
            logger.warn("[Lola] could not decode location of Lola plugin.");
        }
        String separator = System.getProperty("file.separator");
        lolaPath.append((mylocation.substring(0, mylocation.lastIndexOf("/")))
                        .replace("%20", " "));
        lolaPath.append(separator + "lib" + separator);
        if (logger.isDebugEnabled()) {
            logger.debug("[Lola] computed lib path: " + lolaPath.toString());
        }

        MenuManager mm = current.getMenuManager();
        _menu = new CommandMenu("Lola Integration");
        _menu.add(new OpenLolaGUICommand("Show Lola GUI", lolaPath.toString()),
                        KeyEvent.VK_8);
        // export already captured by exportHolder, no need for additional place 
        //_menu.add(new ExportToLolaCommand("export net"));
        _menu.add(new CheckAllTasksCommand("Check all verification tasks"));
        _menu.add(new CheckVerificationRequestCommand("Check selected request",
                        lolaPath.toString()), KeyEvent.VK_4);
        _menu.add(new CheckSelectedTransitionCommand(
                        "Check selected Transitions", lolaPath.toString()));
        _menu.add(new CheckSelectedPlaceCommand("Check selected Places",
                        lolaPath.toString()));
        _menu.add(new CheckAllCommand("Check all places and transitions",
                        lolaPath.toString()));
        _menu.add(new CheckLivenessCommand("Check liveness",
                        lolaPath.toString()));
        _menu.add(new VersionInfoCommand(this));
        _menu.putClientProperty(MenuManager.ID_PROPERTY, "de.renew.lola");

        if (PluginProperties.getUserProperties().getBoolProperty(
                        GuiPlugin.USE_VERIFICATION_MENU_PROP_NAME, false)) {
            mm.registerMenu(GuiPlugin.VERIFICATION_MENU, _menu, 3, 2);
        } else {
            mm.registerMenu(DrawPlugin.TOOLS_MENU, _menu); // default
        }
    }

    /**
     * Returns the path of Lola
     *
     * @return lolapath
     */
    static public String getLolaPath() {
        return lolaPath.toString();
    }

    /**
     * Returns the current running instance of LolaPlugin
     *
     * @return
     */
    public static LolaPlugin getCurrent() {
        Iterator<IPlugin> plugins = PluginManager.getInstance()
                        .getPluginsProviding("de.renew.lola").iterator();
        while (plugins.hasNext()) {
            Object plugin = plugins.next();
            if (plugin instanceof LolaPlugin) {
                return (LolaPlugin) plugin;
            }
        }
        return null;
    }
}