/*
 * @author Timo Carl
 * Created: 06.05.2004
 *
 */
package de.renew.plugin;


/**
 * Callback interface for events that are generated by the Pluginmanager.
*/
public interface IPluginManagerListener {

    /**
     * function is called when a new service has been added to Renew.
     * @param service [String] identifier of the Service
     * @param provider [{@link IPlugin}] plugin which provides the service
     */
    public void serviceAdded(String service, IPlugin provider);

    /**
     * function is called when a service has been removed from Renew.
     * @param service [String] identifier of the Service
     * @param provider [{@link IPlugin}] plugin which provides the service
     */
    public void serviceRemoved(String service, IPlugin provider);
}