package de.renew.io.importFormats;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.importFormats.ImportFormatAbstract;

import de.renew.gui.ShadowNetSystemRenderer;

import de.renew.io.SNSFileFilter;

import java.net.URL;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * Implementation of ImportFormat for SNS files.
 */
public class SNSImportFormat extends ImportFormatAbstract {
    // Attributes
    // Constructor
    public SNSImportFormat() {
        super("ShadowNet System", new SNSFileFilter());
    }


    // Methods


    /**
     * @see de.renew.io.ImportFormat#importFiles(java.io.File[])
     */
    @Override
    public List<Drawing> importFiles(URL[] files) throws Exception {
        if (files == null) {
            return Collections.emptyList();
        }

        List<Drawing> list = new ArrayList<Drawing>();
        for (int pos = 0; pos < files.length; pos++) {
            list.addAll(importFiles(files[pos]));
        }
        return list;
    }

    /**
     * Returns a list of all drawings in the file.
     * @require file != null
     * @ensure result != null
     * @param file the SNS file to be imported.
     * @return Enumeration, list of all imported drawings.
     * @throws Exception, is thrown in case of failure during import of file.
     */
    protected List<Drawing> importFiles(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }

        return ShadowNetSystemRenderer.render(file);
    }
}