package de.renew.io.importFormats;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.importFormats.ImportFormatAbstract;

import de.renew.gui.pnml.PNMLFormat;

import de.renew.io.PNMLFileFilter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import java.net.URL;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * Implementation of ImportFormat for PNML files.
 */
public class PNMLImportFormat extends ImportFormatAbstract {
    public PNMLImportFormat() {
        super("PNML", new PNMLFileFilter());
    }

    /**
     * @see de.renew.io.ImportFormat#importFiles(java.io.File[])
     */
    @Override
    public List<Drawing> importFiles(URL[] files) throws Exception {
        List<Drawing> list = new ArrayList<Drawing>();
        if (files != null) {
            for (int pos = 0; pos < files.length; pos++) {
                list.addAll(importFile(files[pos]));
            }
        }
        return list;
    }

    /**
     * Returns a list of all drawings in the file.
     * @require file != null
     * @ensure result != null
     * @param file the PNML file to be imported.
     * @return Enumeration, list of all imported drawings.
     * @throws Exception, is thrown in case of failure during import of file.
     */
    protected List<Drawing> importFile(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }

        InputStream stream = file.openStream();
        PNMLFormat format = new PNMLFormat();
        List<Drawing> result = format.parse(stream);
        stream.close();
        return result;
    }

    /**
     * Returns a list of all drawings in the file.
     * @require file != null or != ""
     * @ensure result != null
     * @param src the PNML file to be imported.
     * @return Enumeration, list of all imported drawings.
     * @throws Exception, is thrown in case of failure during import of file.
     */
    public List<Drawing> importFile(String src) throws Exception {
        if (src == null || src == "") {
            return Collections.emptyList();
        }

        PNMLFormat format = new PNMLFormat();
        return format.parse(new ByteArrayInputStream(src.getBytes()));
    }
}