package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;

import de.renew.gui.CPNDrawing;
import de.renew.gui.pnml.PNMLFormat;

import de.renew.io.PNMLFileFilter;

import java.io.File;
import java.io.FileOutputStream;


public abstract class PNMLExportFormat extends ExportFormatAbstract {
    public static String ptNetType = "http://www.pnml.org/version-2009/grammar/ptnet";
    public static String refNetType = "RefNet";
    private String _type;
    private boolean _toolInsc;

    public PNMLExportFormat(String name, String type, boolean toolInsc) {
        super("PNML-" + name, new PNMLFileFilter());
        _type = type;
        _toolInsc = toolInsc;
    }

    /**
     * @see de.renew.io.ExportFormat#canExportNto1()
     */
    @Override
    public boolean canExportNto1() {
        return true;
    }

    /**
     * @see de.renew.io.ExportFormat#export(CH.ifa.draw.framework.Drawing, java.net.URI)
     */
    @Override
    public File export(Drawing drawing, File path) throws Exception {
        if (drawing != null && path != null) {
            FileOutputStream stream = new FileOutputStream(path);
            PNMLFormat format = new PNMLFormat(_type, _toolInsc);
            format.write(stream, (CPNDrawing) drawing);
            return path;
        }

        return null;
    }

    /**
     * @see de.renew.io.ExportFormat#export(CH.ifa.draw.framework.Drawing[], java.net.URI)
     */
    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        if (drawings != null && path != null) {
            FileOutputStream stream = new FileOutputStream(path);
            PNMLFormat format = new PNMLFormat(_type, _toolInsc);
            CPNDrawing[] cpn = new CPNDrawing[drawings.length];
            for (int pos = 0; pos < cpn.length; pos++) {
                cpn[pos] = (CPNDrawing) drawings[pos];
            }
            format.write(stream, cpn);
            return path;
        }

        return null;
    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}