package de.renew.gui.pnml.creator;

import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.Converter;

import org.w3c.dom.Element;


public class TransitionCreator extends NodeCreator {
    public TransitionCreator(Converter converter) {
        super("transition", converter);
    }

    @Override
    protected void doCreateObject(PNMLCreator pnmlCreator, Element element) {
        final String subtype = ((TransitionFigure) getFigure())
                        .transitionSubtype();

        // If it is a subtype of a normal transition store this as additional information
        // in a toolspecific element:
        if (subtype != null) {
            final Element subtypeEle = pnmlCreator.createElement("subtype");
            subtypeEle.setAttribute("name", subtype);
            subtypeEle.setAttribute("class",
                            getFigure().getClass().getCanonicalName());

            final Element toolspecificEle = pnmlCreator.createToolspecific();
            toolspecificEle.appendChild(subtypeEle);

            element.appendChild(toolspecificEle);
        }
    }
}