package de.renew.gui.pnml.creator;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;

import java.io.IOException;
import java.io.OutputStream;

import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;


public class PNMLCreator {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(PNMLCreator.class);
    private static String xmlNamespace = "http://www.pnml.org/version-2009/grammar/pnml";
    private String _netType;
    private boolean _toolInsc;
    private Document _doc;

    public PNMLCreator(String netType, boolean toolInsc) {
        _netType = netType;
        _toolInsc = toolInsc;
    }

    private static Transformer createTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance()
                            .newTransformer();
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            transformer.setOutputProperty(
                            "{http://xml.apache.org/xslt}indent-amount", "3");
            return transformer;
        } catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Initialize the document element with a single drawing.
     *
     * @return place figures in the order they occur in the PNML document
     */
    public List<PlaceFigure> setDrawings(CPNDrawing drawing)
                    throws ParserConfigurationException {
        makeDoc();
        return addNet(drawing);
    }

    private void setDrawings(CPNDrawing[] drawings)
                    throws ParserConfigurationException {
        makeDoc();
        for (int pos = 0; pos < drawings.length; pos++) {
            addNet(drawings[pos]);
        }
    }

    public void write(OutputStream stream, CPNDrawing drawing)
                    throws Exception {
        setDrawings(drawing);
        writeXML(stream);
    }

    public void write(OutputStream stream, CPNDrawing[] drawings)
                    throws Exception {
        setDrawings(drawings);
        writeXML(stream);
    }

    private void makeDoc() throws ParserConfigurationException {
        DOMImplementation di = DocumentBuilderFactory.newInstance()
                        .newDocumentBuilder().getDOMImplementation();

        DocumentType dt = di.createDocumentType("PNMLFile", null, null);
        _doc = di.createDocument(xmlNamespace, "pnml", dt);
    }

    private List<PlaceFigure> addNet(CPNDrawing drawing) {
        Element eRoot = _doc.getDocumentElement();
        NetCreator netCreator = new NetCreator(_netType, _toolInsc);
        eRoot.appendChild(netCreator.createElement(this, drawing));
        return netCreator.getPlaceList();
    }

    private void writeXML(OutputStream stream) {
        Transformer transformer = createTransformer();
        DOMSource source = new DOMSource(_doc);
        StreamResult result = new StreamResult(stream);
        try {
            transformer.transform(source, result);
        } catch (TransformerException e) {
            logger.error(PNMLCreator.class.getSimpleName() + ": "
                            + e.getLocalizedMessage(), e);
        }

        try {
            stream.flush();
        } catch (IOException e) {
            // ignore
        }
    }

    /**
     * Create a tag with the given name within the document.
     * Returns {@link Document#createElement(String)}.
     */
    public Element createElement(String tagName) {
        return _doc.createElement(tagName);
    }

    public Element createToolspecific() {
        Element toolSpec = createElement("toolspecific");
        toolSpec.setAttribute("tool", "renew");
        toolSpec.setAttribute("version", "2.0");
        return toolSpec;
    }

    public Element createTextElement(String text) {
        Element element = createElement("text");
        element.appendChild(_doc.createTextNode(text));
        return element;
    }

    public Element getDocumentElement() {
        return _doc.getDocumentElement();
    }
}