package de.renew.gui.pnml.creator;

import org.w3c.dom.Element;

import de.renew.gui.pnml.converter.GraphicConverter;

import java.awt.Color;


public class GraphicCreator {
    private PNMLCreator _pnmlCreator;
    private Element _element;
    private Element line;

    public GraphicCreator(PNMLCreator pnmlCreator) {
        _element = pnmlCreator.createElement("graphics");
        _pnmlCreator = pnmlCreator;
    }

    protected Element getElement() {
        return _element;
    }

    public void addPosition(int x, int y) {
        Element position = _pnmlCreator.createElement("position");
        position.setAttribute("x", String.valueOf(x));
        position.setAttribute("y", String.valueOf(y));
        _element.appendChild(position);
    }

    public void addOffset(int x, int y) {
        Element offset = _pnmlCreator.createElement("offset");
        offset.setAttribute("x", String.valueOf(x));
        offset.setAttribute("y", String.valueOf(y));
        _element.appendChild(offset);
    }

    public void addDimension(int x, int y) {
        Element dimension = _pnmlCreator.createElement("dimension");
        dimension.setAttribute("x", String.valueOf(x));
        dimension.setAttribute("y", String.valueOf(y));
        _element.appendChild(dimension);
    }

    public void addFill(Color c) {
        Element fill = _pnmlCreator.createElement("fill");
        fill.setAttribute("color", "rgb(" + c.getRed() + "," + c.getGreen()
                        + "," + c.getBlue() + ")");
        _element.appendChild(fill);
    }

    public void addLineColor(Color c) {
        getLineElement().setAttribute("color", "rgb(" + c.getRed() + ","
                        + c.getGreen() + "," + c.getBlue() + ")");
    }

    public void addLineStyle(String style) {
        getLineElement().setAttribute("style",
                        GraphicConverter.instance().parseRenewLineStyle(style));
    }

    public void addLine() {
        _element.appendChild(getLineElement());
    }

    private Element getLineElement() {
        if (line == null) {
            line = _pnmlCreator.createElement("line");
        }
        return line;
    }
}