package de.renew.gui.pnml.creator;

import org.w3c.dom.Element;

import CH.ifa.draw.framework.FigureWithID;

import de.renew.gui.ArcConnection;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.converter.NetConverter;


/**
 * A creator for the PNML element representing an arbitrary Java object.
 * The PNML element is a tag with the name given in {@link #ElementCreator(String, Converter)}.
 * The represented Java object is given in {@link #createElement(PNMLCreator, Object)}
 * and the PNML tag {@link Element} is returned.
 */
public abstract class ElementCreator {
    private String _tag;
    private Object _object;
    private Converter _converter;

    public ElementCreator(String tag, Converter converter) {
        _tag = tag;
        _converter = converter;
    }

    String xmlID(FigureWithID figure) {
        final String prefix = figure instanceof PlaceFigure ? "p"
                        : figure instanceof TransitionFigure ? "t"
                                        : figure instanceof ArcConnection ? "a"
                                                        : "id";

        return prefix + String.valueOf(figure.getID()) + "_"
                        + _converter.getNetID();
    }

    Object getObject() {
        return _object;
    }

    Converter getConverter() {
        return _converter;
    }

    NetConverter getNetConverter() {
        return _converter.getNetConverter();
    }

    /**
     * Creates an empty PNML tag with the name given to {@link #ElementCreator(String, Converter)}.
     */
    protected Element doCreateElement(PNMLCreator pnmlCreator) {
        return pnmlCreator.createElement(_tag);
    }

    public Element createElement(PNMLCreator pnmlCreator, Object object) {
        _object = object;
        return doCreateElement(pnmlCreator);
    }
}