package de.renew.gui.pnml.creator;

import org.w3c.dom.Element;

import CH.ifa.draw.framework.FigureWithID;

import de.renew.gui.ArcConnection;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.gui.pnml.converter.Converter;

import de.renew.shadow.ShadowArc;

import java.awt.Color;
import java.awt.Point;


/**
 * Creates PNML {@code arc} tags from an {@link ArcConnection} object.
 */
public class ArcCreator extends ObjectCreator {
    private VirtualPlaceFigure virStart = null;
    private VirtualPlaceFigure virEnd = null;

    /**
     * Create an XMLCreator that parses Renew arcs
     */
    public ArcCreator(Converter converter) {
        super("arc", converter);
    }

    public void setVirStart(VirtualPlaceFigure vir) {
        virStart = vir;
    }

    public void setVirEnd(VirtualPlaceFigure vir) {
        virEnd = vir;
    }

    /**
     * The ArcConnection returned is the figure saved with this object cast to an ArcConnection
     * @return an ArcConnection
     */
    protected ArcConnection getArc() {
        return (ArcConnection) getFigure();
    }

    /* (non-Javadoc)
     * @see de.renew.gui.pnml.ObjectCreator#doCreateAttribute()
     */
    @Override
    protected void doCreateAttribute(PNMLCreator pnmlCreator, Element element) {
        String attributeValue;
        switch (getArc().getArcType()) {
        case ShadowArc.both:
            attributeValue = "both";
            break;
        case ShadowArc.inhibitor:
            attributeValue = "inhibitor";
            break;
        case ShadowArc.test:
            attributeValue = "test";
            break;
        case ShadowArc.doubleHollow:
            attributeValue = "clear";
            break;
        case ShadowArc.doubleOrdinary:
            attributeValue = "multi-ordinary";
            break;

        // case ShadowArc.ordinary:
        default:
            // Abort: don't store the ordinary type.
            // In the case of P/T nets no type attribute is allowed,
            // but since all P/T net arcs are ordinary, none will be added.
            return;
        }

        AttributeCreator creator = new AttributeCreator(pnmlCreator, "type");
        element.appendChild(creator.createElement(attributeValue));
    }

    /* (non-Javadoc)
     * @see de.renew.gui.pnml.ObjectCreator#doCreateGraphic(de.renew.gui.pnml.GraphicCreator)
     */
    @Override
    protected void doCreateGraphic(GraphicCreator creator) {
        int count = getArc().pointCount();
        for (int pos = 1; pos < count - 1; pos++) {
            Point p = getArc().pointAt(pos);
            creator.addPosition(p.x, p.y);
        }
        Color c = (Color) (getFigure()).getAttribute("FrameColor");
        creator.addLineColor(c);
        String s = (String) (getFigure()).getAttribute("LineStyle");
        creator.addLineStyle(s);
        creator.addLine();
    }

    /* (non-Javadoc)
     * @see de.renew.gui.pnml.ObjectCreator#doCreateObject()
     */
    @Override
    protected void doCreateObject(PNMLCreator pnmlCreator, Element element) {
        FigureWithID source = (FigureWithID) getArc().startFigure();
        FigureWithID target = (FigureWithID) getArc().endFigure();

        element.setAttribute("source", xmlID(source));
        element.setAttribute("target", xmlID(target));

        if (virStart != null || virEnd != null) {
            Element toolSpecific = pnmlCreator.createToolspecific();

            if (virStart != null) {
                toolSpecific.setAttribute("source", xmlID(virStart));
            }
            if (virEnd != null) {
                toolSpecific.setAttribute("target", xmlID(virEnd));
            }

            element.appendChild(toolSpecific);
        }
    }
}