package de.renew.gui.pnml.converter;

import org.w3c.dom.Element;

import CH.ifa.draw.figures.TextFigure;

import de.renew.gui.CPNTextFigure;

import de.renew.io.exportFormats.PNMLExportFormat;


public class RefNetConverter extends NetConverterAbstract {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(RefNetConverter.class);

    public RefNetConverter(Converter converter, boolean toolInsc) {
        super(converter, toolInsc);
    }

    @Override
    public boolean isAttribute(String tagName) {
        return "type".equals(tagName) || "placeType".equals(tagName);
    }

    @Override
    public boolean isAnnotation(Element label) {
        String tagName = label.getNodeName();
        return super.isAnnotation(label) || tagName.equals("annotation")
                        || tagName.equals("label") || tagName.equals("guard")
                        || tagName.equals("uplink")
                        || tagName.equals("downlink")
                        || tagName.equals("action") || tagName.equals("create")
                        || tagName.equals("expression");
    }

    @Override
    public boolean isInRenewAnnotation(Element label) {
        return label.getNodeName().equals("placeType");
    }

    @Override
    public TextFigure convertAnnotationToTextFigure(Element label) {
        String tagName = label.getNodeName();
        if (tagName.equals("guard") || tagName.equals("downlink")
                        || tagName.equals("uplink") || tagName.equals("action")
                        || tagName.equals("create")
                        || tagName.equals("expression")
                        || tagName.equals("placeType")) {
            return new CPNTextFigure(CPNTextFigure.INSCRIPTION);
        }

        return super.convertAnnotationToTextFigure(label);
    }

    public static boolean isNetParser(String netType) {
        return PNMLExportFormat.refNetType.equals(netType);
    }

    @Override
    public boolean createPageTag() {
        return false;
    }
}