package de.renew.gui.pnml.converter;

import org.w3c.dom.Element;

import CH.ifa.draw.figures.TextFigure;

import de.renew.gui.CPNTextFigure;
import de.renew.gui.pnml.creator.PNMLCreator;


/**
 * Used to convert between the contents of a {@link de.renew.gui.CPNDrawing}
 * (in the form of {@link CH.ifa.draw.framework.Figure} objects)
 * and the contents of an {@link Element} representing the same net
 * in a PNML file.
 * <p>
 * See also {@link Converter}.
 */
public interface NetConverter {

    /**
     * {@link #isAttribute(String)} for the name of the PNML tag given as an {@link Element}.
     */
    public boolean isAttribute(Element label);

    /**
     * If true the tag with the given name should be created with {@link de.renew.gui.pnml.creator.AttributeCreator},
     * otherwise with {@link de.renew.gui.pnml.creator.AnnotationCreator}.
     */
    public boolean isAttribute(String tagName);

    /**
     * Whether the label should be parsed by the {@link de.renew.gui.pnml.parser.AnnotationParser}.
     */
    public boolean isAnnotation(Element label);

    public boolean isInRenewAnnotation(Element label);

    /**
     * Create a {@link CPNTextFigure} with the right type
     * by calling {@link CPNTextFigure#CPNTextFigure(int)}.
     */
    public TextFigure convertAnnotationToTextFigure(Element annotation);

    /**
     * Check the given annotation figure for syntax errors,
     * generate the corresponding tag structure
     * and return it as an {@link Element}.
     */
    public Element annotationToPNML(CPNTextFigure figure,
                                    PNMLCreator pnmlCreator,
                                    boolean parentVirtual);

    public String convertAttributeNameToRenewName(Element attribute);

    /**
     * Whether to create a {@code page} tag within the {@code net} tag.
     */
    public boolean createPageTag();
}