package de.renew.formalism.java;

public class TimedExpression implements ArcInscription {
    private TypedExpression expr;
    private TypedExpression timeExpr;

    public TimedExpression(TypedExpression expr, TypedExpression timeExpr) {
        this.expr = expr;
        this.timeExpr = timeExpr;
    }

    @Override
    public TypedExpression getExpression() {
        return expr;
    }

    @Override
    public TypedExpression getTime() {
        return timeExpr;
    }

    @Override
    public boolean isTimed() {
        return timeExpr != null;
    }

    @Override
    public String toString() {
        final int sbSize = 1000;
        final String variableSeparator = ", ";
        final StringBuffer sb = new StringBuffer(sbSize);
        sb.append("TimedExpr(");
        sb.append("time: ").append(timeExpr);
        sb.append(variableSeparator);
        sb.append(expr);
        sb.append(")");
        return sb.toString();
    }
}