package de.renew.formalism.java;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;

import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.arc.Arc;

import de.renew.shadow.SyntaxException;


public class SimpleArcFactory implements ArcFactory {
    int arcType;
    boolean allowsTime;

    public SimpleArcFactory(int arcType, boolean allowsTime) {
        this.arcType = arcType;
        this.allowsTime = allowsTime;
    }

    @Override
    public void emptyArcCheck() {
    }

    @Override
    public boolean allowsTime() {
        return allowsTime;
    }

    protected Arc getArc(Place place, Transition transition, int arcType,
                         Expression expr, Expression timeExpr) {
        return new Arc(place, transition, arcType, expr, timeExpr);
    }

    @Override
    public void compileArc(Place place, Transition transition, boolean trace,
                           Class<?> placeType, ArcInscription insc)
                    throws SyntaxException {
        Expression expr;
        if (arcType == Arc.out) {
            expr = JavaNetHelper.makeCastedOutputExpression(placeType,
                            insc.getExpression());
        } else {
            expr = JavaNetHelper.makeCastedInputExpression(placeType,
                            insc.getExpression());
        }

        Expression timeExpr = null;
        if (allowsTime) {
            if (insc.isTimed()) {
                timeExpr = insc.getTime().getExpression();
            } else {
                timeExpr = ConstantExpression.doubleZeroExpression;
            }
        }

        Arc arc = getArc(place, transition, arcType, expr, timeExpr);
        arc.setTrace(trace);
        transition.add(arc);
    }
}