package de.renew.formalism.function;

import de.renew.util.Types;


public class DynamicMethodFunction extends AbstractMethodFunction {
    String method;

    public DynamicMethodFunction(String method) {
        this.method = method;
    }

    @Override
    public Object doFunction(Object obj, Object[] paramArr) throws Exception {
        return Executor.executeMethod(obj.getClass(), obj, method, paramArr);
    }

    @Override
    public String toString() {
        return "DynamicMethodFunc: " + Executor
                        .renderMethodSignature(Types.UNTYPED, method, null);
    }
}