package de.renew.gui.fs;

import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.TypeSystem;

import CH.ifa.draw.figures.TextFigure;

import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.ParentFigure;

import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.RelativeLocator;

import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.ExtendedFont;
import CH.ifa.draw.util.Fontkit;

import de.renew.formalism.fs.ShadowConcept;

import de.renew.gui.NodeFigure;

import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;

import de.renew.util.StringUtil;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

import java.io.IOException;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class ConceptFigure extends TextFigure implements NodeFigure {
    private static final String STEREOTYPE_REGEXP = "^((?:<<|«)([a-zA-Z]*)(?:>>|»))\\n*";

    // group 0: whole match, group 1: comment, group 2: annotations, group 3: concept name
    private static final String CONCEPT_REGEXP = "(/\\*(?:[^*]|\\*[^/])*\\*/)?\n*((?:@[^\\n]*\n)*)\\n*([\\.\\:\\_a-zA-Z0-9-]*)";

    // group 0: whole match, group 1: comment, group 2: annotations, group 3: slot declaration
//    private static final String SLOT_REGEXP =    "(/\\*(?:[^*]|\\*[^/])*\\*/)?\n*((?:@[^\\n]*\n)*)\\n*([a-zA-Z0-9-+_\\(\\)\\.]*\\s*:\\s*[a-zA-Z0-9-\\*]*)";
    private static final String SLOT_REGEXP =    "\n*(/\\*(?:[^*]|\\*[^/])*\\*/)?\n*((?:@[^\\n]*\n)*)\\n*([^\n]+\n*)";
    
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                    .getLogger(ConceptFigure.class);
    private static IsaConnection fgIsaPrototype = new IsaConnection();
    private static IsaConnection fgDisIsaPrototype = new IsaConnection(false);
    private static AssocConnection fgAssocPrototype = new AssocConnection();
    private String conceptStr = "";
    private String appropStr = "";
    private int typeIndex = 0; // line index of type name

    /**
     * The shadow of this place figure.
     * Initially <code>null</code>, will be created
     * when needed.
     * <p>
     * This field is transient because its information
     * can be regenerated via <code>buildShadow(...)</code>.
     * </p>
     **/
    private transient ShadowConcept shadow = null;
    private String textWithDoc;
    private String stereotype;
    private List<String> slotDocumentation = new ArrayList<String>();
    private String conceptDocumentation;
    private List<String> slotAnnotation = new ArrayList<String>();
    private String conceptAnnotation;

    public ConceptFigure() {
        super();
        setFrameColor(ColorMap.color("Black"));
        setFillColor(ColorMap.color("White"));
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = super.handles();
        handles.addElement(new ConnectionHandle(this, RelativeLocator.north(),
                        fgDisIsaPrototype));
        handles.addElement(new ConnectionHandle(this, RelativeLocator.south(),
                        fgIsaPrototype));
        handles.addElement(new ConnectionHandle(this, RelativeLocator.east(),
                        fgAssocPrototype));


        //handles.addElement(new ConnectionHandle(this, RelativeLocator.west(),
        //				    fgAssocPrototype));
        // Add association handles for all lines that contain an attribute.
        String[] lines = getLines();
        Rectangle size = displayBox();
        Rectangle[] boxes = getLineBoxes(null);
        int yOffset = 0;
        boolean skippedClassName = false;
        if (boxes != null) {
            for (int i = 0; i < lines.length; i++) {
                Locator locator = new RelativeLocator(0.0,
                                (2 * yOffset + boxes[i].height) / 2.0
                                                / size.height);
                yOffset += boxes[i].height;
                if ("".equals(lines[i])) {
                    // Ignore.
                } else if (isStereotype(lines[i])) {
                    // Ignore.
                } else if (isAnnotation(lines[i])) {
                    // Ignore.
                } else if (skippedClassName) {
                    // Split at colon.
                    String name = null;
                    String type = null;
                    StringTokenizer tokenizer = new StringTokenizer(lines[i],
                                    ":");
                    while (type == null && tokenizer.hasMoreTokens()) {
                        if (name == null) {
                            name = tokenizer.nextToken();
                        } else {
                            type = tokenizer.nextToken();
                        }
                    }

                    if (name != null && !tokenizer.hasMoreTokens()) {
                        // Ok, all tokens are used up. Clear spaces.
                        name = StringUtil.unspace(name);
                        if (type != null) {
                            type = StringUtil.unspace(type);
                        }

                        if (name != null) {
                            if (type == null) {
                                type = "UNKNOWN";
                            }

                            // Split preceeding modifiers.
                            String frontModifier = "";
                            if (name.startsWith("#") || name.startsWith("+")
                                            || name.startsWith("-")) {
                                frontModifier = name.substring(0, 1);
                                name = StringUtil.unspace(name.substring(1));
                            }

                            String backModifiers = "";

                            // Split of modifier list enclosed in braces.
                            int bracePos = type.indexOf("{");
                            if (bracePos >= 0) {
                                backModifiers = " " + type.substring(bracePos);
                                type = StringUtil.unspace(
                                                type.substring(0, bracePos));
                            }

                            boolean isCollection = false;
                            while (type != null && type.endsWith("[]")) {
                                isCollection = true;
                                type = type.substring(0, type.length() - 2);
                            }

                            if (StringUtil.isNameOrEmpty(name, false)
                                            && StringUtil.isNameOrEmpty(type,
                                                            true)) {
                                // This seems to be an attribute declaration, not a
                                // method call.
                                // Reattach the modifiers that were previously removed.
                                type = "." + type;
                                if (!"".equals(frontModifier)) {
                                    // How is the accesibility indicated for an association?
                                    // name=frontModifier+" "+name;
                                    // Use the field's accesibility for diplaying the class.
                                    // Is there a better solution?
                                    type = frontModifier + type;
                                }
                                name = StringUtil.unspace(name + backModifiers);


                                // Create the handle.
                                handles.addElement(new AssociationHandle(this,
                                                i, name, type, isCollection,
                                                locator, fgAssocPrototype));
                            }
                        }
                    }
                } else {
                    skippedClassName = true;
                    // Line should be class name. Skip.
                }
            }
        }
        return handles;
    }

    /* hack for setting ConceptFigures to editable: */
    @Override
    public void read(CH.ifa.draw.util.StorableInput dr) throws IOException {
        super.read(dr);
        setReadOnly(false);


        /* hack for getting rid of parent PartitionFigure: */
        setParent(null);
    }

    private static boolean isStereotype(String str) {
        return str.startsWith("<<") || str.startsWith("\u00ab");
    }

    private static boolean isAnnotation(String str) {
        return str.startsWith("@");
    }

    public String getStereotype() {
        Pattern pattern = Pattern.compile(STEREOTYPE_REGEXP);
        Matcher stereotypeMatcher = pattern.matcher(stereotype);
        if (stereotype.length() > 0) {
            if (stereotypeMatcher.find()) {
                return stereotypeMatcher.group(2);
            } else {
                logger.error("The concept figure " + conceptStr
                                + " does not follow the syntax rules in its stereotype specification: "
                                + stereotype + ".");
                return null;
            }
        }
        return stereotype;
    }

    @Override
    protected void drawLine(Graphics g, int i) {
        if (!"".equals(getLine(i))) {
            super.drawLine(g, i);
        } else {
            int y = getLineBox(g, i).y;
            int width = displayBox().width;
            g.drawLine(-5, y + 1, width - 6, y + 1);
        }
    }

    @Override
    protected String getLine(int i) {
        String line = super.getLine(i);
        if (line.startsWith("\\") || line.startsWith("_")) {
            return line.substring(1);
        }
        return line;
    }

    @Override
    protected Font getLineFont(int i) {
        String line = super.getLine(i);
        Font font = super.getLineFont(i); //NOTICEsignature
        int fontStyle = font.getStyle();
        if (i == typeIndex) {
            fontStyle |= Font.BOLD;
        }
        if (line.length() > 0) { // should be, otherwise getLineFont is not called.
            char styleChar = line.charAt(0);
            switch (styleChar) {
            case '\\':
                fontStyle |= Font.ITALIC;
                break;
            case '_':
                fontStyle |= ExtendedFont.UNDERLINED;
            }
        }
        return Fontkit.getFont(font.getName(), fontStyle, font.getSize());
    }

    @Override
    protected int getLineAlignment(int i) {
        if (i <= typeIndex) {
            return AlignCommand.CENTERS;
        }
        return super.getLineAlignment(i); //NOTICEsignature
    }

    @Override
    protected Dimension getLineDimension(int i, Graphics g) {
        if ("".equals(getLine(i))) {
            return new Dimension(0, 3);
        }
        return super.getLineDimension(i, g);
    }

    @Override
    public void setText(String text) {
        if (text.equals(textWithDoc)) {
            return;
        }
        typeIndex = 0;
        appropStr = "";
        
        // strip javadoc comments from the shown text
        textWithDoc = text;
        conceptStr = text.trim();
        stereotype = "";
        conceptDocumentation = "";
        slotDocumentation = new ArrayList<String>();
        conceptAnnotation = "";
        slotAnnotation = new ArrayList<String>();
        String textWithDocumentation = textWithDoc;
        
        String implementationDescription = generateImplementationDescription();
        if(implementationDescription!=null) {
            textWithDocumentation = implementationDescription;
        }

        // Match stereotype at beginning
        textWithDocumentation = matchStereotype(textWithDocumentation);

        // Match the concept declaration
        textWithDocumentation = matchConceptDeclaration(textWithDocumentation);
        
        if(implementationDescription!=null) {
            appropStr = textWithDocumentation;
            textWithDoc = text = implementationDescription;
        } else {
            // Match each slot
            matchSlots(textWithDocumentation);            
        }

        willChange();
        basicSetText(appropStr.length()>0? conceptStr+"\n\n"+appropStr: conceptStr);
        changed();
        logger.debug("Concept name: \"" + conceptStr + "\", approp: \""
                        + appropStr + "\"");
    }
    
    private String generateImplementationDescription() {
        if (conceptStr.trim().length() > 0) {

            int level = JavaConcept.getVisibilityLevel(conceptStr.charAt(0));
            if (level >= 0) {
                conceptStr = conceptStr.substring(1);
            }
            boolean wantPackages = conceptStr.startsWith(".");
            if (wantPackages) {
                conceptStr = conceptStr.substring(1);
            }
            TypeSystem ts = TypeSystem.instance();
            try {
                Class<?> clazz = ts.getJavaClass(conceptStr);
                String expandedText;
                String[] wellKnown;
                if (wantPackages) {
                    wellKnown = new String[0];
                } else {
                    wellKnown = JavaConcept.getWellKnownPackages(clazz);
                }
                if (level >= 0) {
                    expandedText = JavaConcept.getImplementationDescription(
                                    clazz, level, wellKnown);
                } else {
                    expandedText = ts.getJavaConcept(clazz)
                                    .getClassDescription(wellKnown);
                }
                return expandedText;
            } catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    private void matchSlots(String textWithDocumentation) {
        Pattern slotPattern = Pattern.compile(SLOT_REGEXP);
        Matcher slotMatcher = slotPattern.matcher(textWithDocumentation);
        List<String> slots = new ArrayList<String>();
        while (slotMatcher.find()) {
            String comment = slotMatcher.group(1);
            String strippedComment = "";
            if (comment != null) {
                strippedComment = comment.substring("/**".length(),
                                                    comment.length()
                                                    - "*/\n".length()).trim();
            }
            slotDocumentation.add(strippedComment);
            String annotations = slotMatcher.group(2);
            slotAnnotation.add((annotations != null) ? annotations : "");
            String slot = slotMatcher.group(3);
            slots.add(slot);
        }
        appropStr = String.join("", slots);
    }

    private String matchConceptDeclaration(String textWithDocumentation) {
        Pattern conceptPattern = Pattern.compile(CONCEPT_REGEXP);
        Matcher conceptMatcher = conceptPattern.matcher(textWithDocumentation);
        if (conceptMatcher.find()) {
            String comment = conceptMatcher.group(1);
            String strippedComment = "";
            if (comment != null) {
                strippedComment = comment.substring("/**".length(),
                                                    comment.length()
                                                    - "*/\n".length()).trim();
            }
            conceptDocumentation = strippedComment;
            String annotations = conceptMatcher.group(2);
            conceptAnnotation = (annotations != null) ? annotations : "";

            conceptStr = stereotype.length() > 0
                            ? stereotype + "\n" + conceptMatcher.group(3)
                            : conceptMatcher.group(3);
            
            // continue with the substring that begins with the slot declarations
            textWithDocumentation = textWithDocumentation.substring(conceptMatcher
                                                                    .end());
        }
        return textWithDocumentation;
    }

    private String matchStereotype(String textWithDocumentation) {
        Pattern stereotypePattern = Pattern.compile(STEREOTYPE_REGEXP);
        Matcher stereotypeMatcher = stereotypePattern.matcher(textWithDocumentation);
        if (stereotypeMatcher.find()) {
            stereotype = stereotypeMatcher.group(1);
            if(stereotype.length()>0) {
                typeIndex = 1;
            }
            textWithDocumentation = textWithDocumentation.substring(stereotypeMatcher.end());
        }
        return textWithDocumentation;
    }

    @Override
    protected void internalSetText(String newText) {
        // A bit ugly, but we can't use an initializer here,
        // as this method is called from the parent-constructor
        // when the initializer has not been run.
        if (textWithDoc == null) {
            textWithDoc = newText;
        }
        super.internalSetTextHiddenParts(textWithDoc, newText);
    }

    @Override
    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        return new Rectangle(box.x - 5, box.y, box.width + 10, box.height + 1);
    }

    /** Build a shadow in the given shadow net.
      *  This shadow is stored as well as returned.
      */
    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        shadow = new ShadowConcept(net, conceptStr, appropStr,
                                   conceptDocumentation, slotDocumentation,
                                   conceptAnnotation, slotAnnotation, stereotype);
        shadow.context = this;
        logger.debug("shadow for concept " + conceptStr + " created!");
        return shadow;
    }

    /** Get the associated shadow, if any.
     */
    @Override
    public ShadowNetElement getShadow() {
        return shadow;
    }

    public String getName() {
//        if(getStereotype().length()>0) {
//            return getStereotype()+"\n"+conceptStr;
//        } else {
            return conceptStr;
//        }
    }

    @Override
    public void release() {
        super.release();
        if (shadow != null) {
            shadow.discard();
        }
    }

    @Override
    public boolean canBeParent(ParentFigure figure) {
        //if (figure instanceof PartitionFigure)
        //  return super.canBeParent(figure);
        // only PartitionFigures can be parents of ConceptFigures!
        //return false;
        return figure == null;
    }
}
